/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.pagination.paginator;

import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.components.Components;
import com.freya02.botcommands.api.components.InteractionConstraints;
import com.freya02.botcommands.api.components.builder.buttons.LambdaButtonBuilder;
import com.freya02.botcommands.api.components.event.ButtonEvent;
import com.freya02.botcommands.api.pagination.BasicPagination;
import com.freya02.botcommands.api.pagination.PaginatorSupplier;
import com.freya02.botcommands.api.pagination.TimeoutInfo;
import com.freya02.botcommands.api.utils.ButtonContent;
import java.util.List;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.interactions.components.ActionComponent;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.utils.messages.MessageEditData;
import net.dv8tion.jda.internal.utils.Checks;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class BasicPaginator<T extends BasicPaginator<T>>
extends BasicPagination<T> {
    private static final Logger LOGGER = Logging.getLogger();
    private static final MessageEditData DELETED_MESSAGE = MessageEditData.fromContent((String)"[deleted]");
    protected final PaginatorSupplier<T> supplier;
    private final Button deleteButton;
    protected int maxPages;
    protected int page = 0;
    private Button firstButton;
    private Button previousButton;
    private Button nextButton;
    private Button lastButton;

    protected BasicPaginator(InteractionConstraints constraints, TimeoutInfo<T> timeout, int _maxPages, PaginatorSupplier<T> supplier, boolean hasDeleteButton, ButtonContent firstContent, ButtonContent previousContent, ButtonContent nextContent, ButtonContent lastContent, ButtonContent deleteContent) {
        super(constraints, timeout);
        this.maxPages = _maxPages;
        this.supplier = supplier;
        this.firstButton = ((LambdaButtonBuilder)Components.primaryButton(e -> {
            this.page = 0;
            e.editMessage(this.get()).queue();
        }).setConstraints(constraints)).build(firstContent);
        this.previousButton = ((LambdaButtonBuilder)Components.primaryButton(e -> {
            this.page = Math.max(0, this.page - 1);
            e.editMessage(this.get()).queue();
        }).setConstraints(constraints)).build(previousContent);
        this.nextButton = ((LambdaButtonBuilder)Components.primaryButton(e -> {
            this.page = Math.min(this.maxPages - 1, this.page + 1);
            e.editMessage(this.get()).queue();
        }).setConstraints(constraints)).build(nextContent);
        this.lastButton = ((LambdaButtonBuilder)Components.primaryButton(e -> {
            this.page = this.maxPages - 1;
            e.editMessage(this.get()).queue();
        }).setConstraints(constraints)).build(lastContent);
        this.deleteButton = hasDeleteButton ? ((LambdaButtonBuilder)((LambdaButtonBuilder)Components.dangerButton(this::onDeleteClicked).setConstraints(constraints)).oneUse()).build(deleteContent) : null;
    }

    public int getMaxPages() {
        return this.maxPages;
    }

    public int getPage() {
        return this.page;
    }

    public T setPage(int page) {
        Checks.check((page >= 0 ? 1 : 0) != 0, (String)"Page cannot be negative");
        Checks.check((page < this.maxPages ? 1 : 0) != 0, (String)"Page cannot be higher than max page (%d)", (Object)this.maxPages);
        this.page = page;
        return (T)this;
    }

    protected void setMaxPages(int maxPages) {
        this.maxPages = maxPages;
    }

    private void onDeleteClicked(ButtonEvent e) {
        this.cancelTimeout();
        if (!e.getMessage().isEphemeral()) {
            e.deferEdit().queue();
            e.getHook().deleteOriginal().queue();
        } else {
            e.editMessage(DELETED_MESSAGE).queue();
            LOGGER.warn("Attempted to delete a ephemeral message using a Paginator delete button, consider disabling the delete button in the constructor or making your message not ephemeral, pagination supplier comes from {}", (Object)this.supplier.getClass().getName());
        }
        this.cleanup(e.getContext());
    }

    @Override
    public MessageEditData get() {
        this.onPreGet();
        this.putComponents();
        MessageEmbed embed = this.getEmbed();
        this.messageBuilder.setEmbeds(new MessageEmbed[]{embed});
        List<ActionRow> rows = this.components.getActionRows();
        this.messageBuilder.setComponents(rows);
        this.onPostGet();
        return this.messageBuilder.build();
    }

    @NotNull
    protected MessageEmbed getEmbed() {
        return this.supplier.get(this, this.messageBuilder, this.components, this.page);
    }

    protected void putComponents() {
        if (this.page == 0) {
            this.previousButton = this.previousButton.asDisabled();
            this.firstButton = this.firstButton.asDisabled();
        } else {
            this.previousButton = this.previousButton.asEnabled();
            this.firstButton = this.firstButton.asEnabled();
        }
        if (this.page >= this.maxPages - 1) {
            this.nextButton = this.nextButton.asDisabled();
            this.lastButton = this.lastButton.asDisabled();
        } else {
            this.nextButton = this.nextButton.asEnabled();
            this.lastButton = this.lastButton.asEnabled();
        }
        if (this.deleteButton != null) {
            this.components.addComponents(new ActionComponent[]{this.firstButton, this.previousButton, this.nextButton, this.lastButton, this.deleteButton});
        } else {
            this.components.addComponents(new ActionComponent[]{this.firstButton, this.previousButton, this.nextButton, this.lastButton});
        }
    }
}

