/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.parameters;

import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.parameters.ComponentParameterResolver;
import com.freya02.botcommands.api.parameters.CustomResolver;
import com.freya02.botcommands.api.parameters.MessageContextParameterResolver;
import com.freya02.botcommands.api.parameters.ParameterResolver;
import com.freya02.botcommands.api.parameters.RegexParameterResolver;
import com.freya02.botcommands.api.parameters.SlashParameterResolver;
import com.freya02.botcommands.api.parameters.UserContextParameterResolver;
import com.freya02.botcommands.internal.parameters.AttachmentResolver;
import com.freya02.botcommands.internal.parameters.BooleanResolver;
import com.freya02.botcommands.internal.parameters.DoubleResolver;
import com.freya02.botcommands.internal.parameters.EmojiResolver;
import com.freya02.botcommands.internal.parameters.GuildResolver;
import com.freya02.botcommands.internal.parameters.IntegerResolver;
import com.freya02.botcommands.internal.parameters.LongResolver;
import com.freya02.botcommands.internal.parameters.MemberResolver;
import com.freya02.botcommands.internal.parameters.MentionableResolver;
import com.freya02.botcommands.internal.parameters.MessageResolver;
import com.freya02.botcommands.internal.parameters.RoleResolver;
import com.freya02.botcommands.internal.parameters.StringResolver;
import com.freya02.botcommands.internal.parameters.UserResolver;
import com.freya02.botcommands.internal.parameters.channels.CategoryResolver;
import com.freya02.botcommands.internal.parameters.channels.ForumChannelResolver;
import com.freya02.botcommands.internal.parameters.channels.GuildChannelResolver;
import com.freya02.botcommands.internal.parameters.channels.NewsChannelResolver;
import com.freya02.botcommands.internal.parameters.channels.StageChannelResolver;
import com.freya02.botcommands.internal.parameters.channels.TextChannelResolver;
import com.freya02.botcommands.internal.parameters.channels.ThreadChannelResolver;
import com.freya02.botcommands.internal.parameters.channels.VoiceChannelResolver;
import com.freya02.botcommands.internal.utils.ReflectionUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ParameterResolvers {
    private static final Logger LOGGER = Logging.getLogger();
    private static final Map<Class<?>, ParameterResolver> map = new HashMap();
    private static final List<Class<?>> possibleInterfaces = List.of(RegexParameterResolver.class, SlashParameterResolver.class, ComponentParameterResolver.class, UserContextParameterResolver.class, MessageContextParameterResolver.class, CustomResolver.class);

    public static void register(@NotNull ParameterResolver resolver) {
        boolean isCompatible = ParameterResolvers.hasCompatibleInterface(resolver);
        if (!isCompatible) {
            throw new IllegalArgumentException("The resolver should implement at least one of these interfaces: " + possibleInterfaces.stream().map(Class::getSimpleName).collect(Collectors.joining(", ")));
        }
        ParameterResolver oldResolver = map.put(resolver.getType(), resolver);
        if (oldResolver != null) {
            LOGGER.warn("An old parameter resolver ({}) got overridden by another ({}) at: {}", new Object[]{oldResolver.getClass().getName(), resolver.getClass().getName(), ReflectionUtils.formatCallerMethod()});
        }
    }

    private static boolean hasCompatibleInterface(@NotNull ParameterResolver resolver) {
        for (Class<?> possibleInterface : possibleInterfaces) {
            if (!possibleInterface.isAssignableFrom(resolver.getClass())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ParameterResolver of(Class<?> type) {
        return map.get(type);
    }

    public static boolean exists(Class<?> type) {
        return map.containsKey(type);
    }

    static {
        ParameterResolvers.register(new BooleanResolver());
        ParameterResolvers.register(new DoubleResolver());
        ParameterResolvers.register(new EmojiResolver());
        ParameterResolvers.register(new GuildResolver());
        ParameterResolvers.register(new LongResolver());
        ParameterResolvers.register(new IntegerResolver());
        ParameterResolvers.register(new MemberResolver());
        ParameterResolvers.register(new MentionableResolver());
        ParameterResolvers.register(new RoleResolver());
        ParameterResolvers.register(new StringResolver());
        ParameterResolvers.register(new GuildChannelResolver());
        ParameterResolvers.register(new TextChannelResolver());
        ParameterResolvers.register(new ThreadChannelResolver());
        ParameterResolvers.register(new ForumChannelResolver());
        ParameterResolvers.register(new VoiceChannelResolver());
        ParameterResolvers.register(new NewsChannelResolver());
        ParameterResolvers.register(new StageChannelResolver());
        ParameterResolvers.register(new CategoryResolver());
        ParameterResolvers.register(new UserResolver());
        ParameterResolvers.register(new MessageResolver());
        ParameterResolvers.register(new AttachmentResolver());
    }
}

