/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.utils;

import com.freya02.botcommands.api.utils.EmojiUtils;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import org.jetbrains.annotations.NotNull;

public record ButtonContent(String text, Emoji emoji) {
    public static ButtonContent withString(@NotNull String text) {
        return new ButtonContent(text, null);
    }

    public static ButtonContent withEmoji(@NotNull Emoji emoji) {
        return new ButtonContent(null, emoji);
    }

    public static ButtonContent withEmoji(@NotNull String text, @NotNull Emoji emoji) {
        return new ButtonContent(text, emoji);
    }

    public static ButtonContent withEmoji(@NotNull String unicode) {
        return new ButtonContent(null, (Emoji)Emoji.fromUnicode((String)unicode));
    }

    public static ButtonContent withEmoji(@NotNull String text, @NotNull String unicode) {
        return new ButtonContent(text, (Emoji)Emoji.fromUnicode((String)unicode));
    }

    public static ButtonContent withShortcode(@NotNull String shortcode) {
        return new ButtonContent(null, EmojiUtils.resolveJDAEmoji(shortcode));
    }

    public static ButtonContent withShortcode(@NotNull String text, @NotNull String shortcode) {
        return new ButtonContent(text, EmojiUtils.resolveJDAEmoji(shortcode));
    }
}

