/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.utils;

import com.freya02.botcommands.api.utils.RichTextConsumer;
import com.freya02.botcommands.api.utils.RichTextType;
import com.vdurmont.emoji.EmojiParser;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RichTextFinder
extends EmojiParser {
    private static final Pattern urlPattern = Pattern.compile("https?://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");
    private static final Pattern EMPTY_PATTERN = Pattern.compile("");
    private final String input;
    private final Matcher matcher;
    private final Map<Integer, RichText> normalMentionMap = new TreeMap<Integer, RichText>();
    private final Map<Integer, String> addedStrs = new TreeMap<Integer, String>();

    public RichTextFinder(String input, boolean getIMentionable, boolean getGlobalMentions, boolean getEmojis, boolean getUrls) {
        this.input = input.replace("\ufe0f", "");
        this.matcher = EMPTY_PATTERN.matcher(this.input);
        if (getIMentionable) {
            this.findAllMentions(RichTextType.USER, RichTextType.USER.getPattern());
            this.findAllMentions(RichTextType.CHANNEL, RichTextType.CHANNEL.getPattern());
            this.findAllMentions(RichTextType.EMOJI, RichTextType.EMOJI.getPattern());
            this.findAllMentions(RichTextType.ROLE, RichTextType.ROLE.getPattern());
        }
        if (getGlobalMentions) {
            this.findAllMentions(RichTextType.HERE, RichTextType.HERE.getPattern());
            this.findAllMentions(RichTextType.EVERYONE, RichTextType.EVERYONE.getPattern());
        }
        if (getEmojis) {
            this.resolveEmojis();
        }
        if (getUrls) {
            this.findAllMentions(RichTextType.URL, urlPattern);
        }
        if (!this.addedStrs.isEmpty()) {
            int startIndex = 0;
            Iterator<String> it = this.addedStrs.values().iterator();
            String next = it.next();
            int endIndex = input.indexOf(next, startIndex);
            String startSubstring = this.input.substring(startIndex, endIndex).trim();
            if (!startSubstring.isEmpty()) {
                this.normalMentionMap.put(startIndex, new RichText(startSubstring, RichTextType.TEXT));
            }
            while (it.hasNext()) {
                startIndex = endIndex + next.length();
                String middleSubstring = this.input.substring(startIndex, endIndex = input.indexOf(next = it.next(), startIndex)).trim();
                if (middleSubstring.isEmpty()) continue;
                this.normalMentionMap.put(startIndex, new RichText(middleSubstring, RichTextType.TEXT));
            }
            startIndex = endIndex + next.length();
            String endSubstring = this.input.substring(startIndex).trim();
            if (!endSubstring.isEmpty()) {
                this.normalMentionMap.put(startIndex, new RichText(endSubstring, RichTextType.TEXT));
            }
            this.addedStrs.clear();
        } else {
            this.normalMentionMap.put(0, new RichText(this.input, RichTextType.TEXT));
        }
    }

    public List<RichText> getResults() {
        return List.copyOf(this.normalMentionMap.values());
    }

    private void resolveEmojis() {
        EmojiParser.UnicodeCandidate next;
        int inputLength = this.input.length();
        for (int last = 0; last < inputLength; ++last) {
            EmojiParser.AliasCandidate alias = RichTextFinder.getAliasAt((String)this.input, (int)last);
            if (alias == null) continue;
            last = alias.endIndex;
            Object substring = alias.fitzpatrick != null ? alias.emoji.getUnicode() + alias.fitzpatrick.unicode : alias.emoji.getUnicode();
            int beginIndex = last;
            boolean isInsideCustomEmote = this.normalMentionMap.values().stream().filter(r -> r.type == RichTextType.EMOJI).anyMatch(r -> {
                List aliases = alias.emoji.getAliases();
                for (String aliasItem : aliases) {
                    boolean customEmoteHasEmoji = r.substring.startsWith(":" + aliasItem + ":", 1);
                    if (!customEmoteHasEmoji) continue;
                    return true;
                }
                return false;
            });
            if (isInsideCustomEmote) continue;
            this.normalMentionMap.put(beginIndex, new RichText((String)substring, RichTextType.UNICODE_EMOTE));
            this.addedStrs.put(beginIndex, this.input.substring(alias.startIndex, alias.endIndex + 1));
        }
        char[] inputCharArray = this.input.toCharArray();
        int i = 0;
        while ((next = RichTextFinder.getNextUnicodeCandidate((char[])inputCharArray, (int)i)) != null) {
            if (next.hasFitzpatrick()) {
                this.normalMentionMap.put(next.getEmojiStartIndex(), new RichText(next.getEmoji().getUnicode(next.getFitzpatrick()), RichTextType.UNICODE_EMOTE));
                this.addedStrs.put(next.getEmojiStartIndex(), next.getEmoji().getUnicode(next.getFitzpatrick()));
            } else {
                this.normalMentionMap.put(next.getEmojiStartIndex(), new RichText(next.getEmoji().getUnicode(), RichTextType.UNICODE_EMOTE));
                this.addedStrs.put(next.getEmojiStartIndex(), next.getEmoji().getUnicode());
            }
            i = next.getFitzpatrickEndIndex();
        }
    }

    private void findAllMentions(RichTextType type, Pattern pattern) {
        this.matcher.usePattern(pattern);
        this.matcher.reset();
        while (this.matcher.find()) {
            String group = this.matcher.group();
            this.normalMentionMap.put(this.matcher.start(), new RichText(group, type));
            this.addedStrs.put(this.matcher.start(), group);
        }
    }

    public void processResults(RichTextConsumer consumer) {
        for (RichText richText : this.normalMentionMap.values()) {
            consumer.consume(richText.substring, richText.type);
        }
    }

    public static class RichText {
        private final String substring;
        private final RichTextType type;

        RichText(String substring, RichTextType type) {
            this.substring = substring;
            this.type = type;
        }

        public String getSubstring() {
            return this.substring;
        }

        public RichTextType getType() {
            return this.type;
        }
    }
}

