/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.waiter;

import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.waiter.CompletedFutureEvent;
import com.freya02.botcommands.api.waiter.EventWaiterBuilder;
import com.freya02.botcommands.internal.utils.EventUtils;
import com.freya02.botcommands.internal.utils.Utils;
import com.freya02.botcommands.internal.waiter.WaitingEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.events.GenericEvent;
import net.dv8tion.jda.api.hooks.EventListener;
import net.dv8tion.jda.api.hooks.SubscribeEvent;
import net.dv8tion.jda.api.requests.GatewayIntent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class EventWaiter
implements EventListener {
    private static final Map<Class<? extends GenericEvent>, List<WaitingEvent<? extends GenericEvent>>> waitingMap = new HashMap<Class<? extends GenericEvent>, List<WaitingEvent<? extends GenericEvent>>>();
    private static final Logger LOGGER = Logging.getLogger();
    private static final Object EVENT_LIST_LOCK = new Object();
    private static int commandThreadNumber = 0;
    private static final ExecutorService waiterCompleteService = Utils.createCommandPool(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(false);
        thread.setUncaughtExceptionHandler((t, e) -> Utils.printExceptionString("An unexpected exception happened in an event waiter thread '" + t.getName() + "':", e));
        thread.setName("Event waiter thread #" + commandThreadNumber++);
        return thread;
    });
    private static JDA jda;
    private static EnumSet<GatewayIntent> intents;
    private static boolean initialized;

    public EventWaiter(@NotNull JDA jda) {
        if (initialized) {
            throw new IllegalStateException("Cannot build an EventWaiter more than once");
        }
        initialized = true;
        LOGGER.debug("Initialized EventWaiter");
        EventWaiter.jda = jda;
        intents = jda.getGatewayIntents();
    }

    public static <T extends GenericEvent> EventWaiterBuilder<T> of(Class<T> eventType) {
        if (!initialized) {
            throw new IllegalStateException("Framework must be constructed before using the EventWaiter");
        }
        EventUtils.checkEvent(jda, intents, eventType);
        return new EventWaiterBuilder<T>(eventType);
    }

    static <T extends GenericEvent> CompletableFuture<T> submit(WaitingEvent<T> waitingEvent) {
        CompletableFuture future = waitingEvent.getCompletableFuture();
        List<WaitingEvent<?>> waitingEvents = EventWaiter.getWaitingEventsByType(waitingEvent);
        if (waitingEvent.getTimeout() > 0L) {
            future.orTimeout(waitingEvent.getTimeout(), waitingEvent.getTimeoutUnit());
        }
        future.whenCompleteAsync((t, throwable) -> {
            CompletedFutureEvent<GenericEvent> onComplete = waitingEvent.getOnComplete();
            if (onComplete != null) {
                onComplete.accept(future, (GenericEvent)t, (Throwable)throwable);
            }
            if (throwable instanceof TimeoutException) {
                Runnable onTimeout = waitingEvent.getOnTimeout();
                if (onTimeout != null) {
                    onTimeout.run();
                }
                Object object = EVENT_LIST_LOCK;
                synchronized (object) {
                    waitingEvents.remove(waitingEvent);
                }
            }
            if (t != null) {
                Consumer<GenericEvent> onSuccess = waitingEvent.getOnSuccess();
                if (onSuccess != null) {
                    onSuccess.accept((GenericEvent)t);
                }
            } else if (future.isCancelled()) {
                Object onSuccess = EVENT_LIST_LOCK;
                synchronized (onSuccess) {
                    waitingEvents.remove(waitingEvent);
                }
                Runnable onCancelled = waitingEvent.getOnCancelled();
                if (onCancelled != null) {
                    onCancelled.run();
                }
            } else {
                LOGGER.warn("Unexpected object received in EventWaiter Future#whenCompleteAsync, please report this to devs");
            }
        }, (Executor)waiterCompleteService);
        waitingEvents.add(waitingEvent);
        return future;
    }

    @NotNull
    private static <T extends GenericEvent> List<WaitingEvent<?>> getWaitingEventsByType(WaitingEvent<T> waitingEvent) {
        return waitingMap.computeIfAbsent(waitingEvent.getEventType(), x -> Collections.synchronizedList(new ArrayList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onEvent(@NotNull GenericEvent event) {
        List<WaitingEvent<? extends GenericEvent>> waitingEvents = waitingMap.get(event.getClass());
        if (waitingEvents != null) {
            Object object = EVENT_LIST_LOCK;
            synchronized (object) {
                Iterator<WaitingEvent<? extends GenericEvent>> iterator = waitingEvents.iterator();
                block3: while (iterator.hasNext()) {
                    WaitingEvent<? extends GenericEvent> waitingEvent = iterator.next();
                    for (Predicate<? extends GenericEvent> p : waitingEvent.getPreconditions()) {
                        Predicate<? extends GenericEvent> precondition = p;
                        if (precondition.test((GenericEvent)event)) continue;
                        continue block3;
                    }
                    CompletableFuture<? extends GenericEvent> completableFuture = waitingEvent.getCompletableFuture();
                    if (completableFuture.complete((GenericEvent)event)) {
                        iterator.remove();
                        continue;
                    }
                    LOGGER.warn("Completable future was already completed somehow, please report to the dev");
                }
            }
        }
    }

    static {
        intents = EnumSet.noneOf(GatewayIntent.class);
    }
}

