/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.waiter;

import com.freya02.botcommands.api.waiter.CompletedFutureEvent;
import com.freya02.botcommands.api.waiter.EventWaiter;
import com.freya02.botcommands.internal.waiter.WaitingEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.dv8tion.jda.api.events.GenericEvent;
import net.dv8tion.jda.internal.utils.Checks;

public class EventWaiterBuilder<T extends GenericEvent> {
    private final Class<T> eventType;
    private final List<Predicate<T>> preconditions = new ArrayList<Predicate<T>>();
    private Consumer<T> onSuccess;
    private Runnable onTimeout;
    private Runnable onCancelled;
    private CompletedFutureEvent<T> onComplete;
    private int timeout;
    private TimeUnit timeoutUnit;

    EventWaiterBuilder(Class<T> eventType) {
        this.eventType = eventType;
    }

    public EventWaiterBuilder<T> setTimeout(int timeout, TimeUnit timeoutUnit) {
        Checks.positive((int)timeout, (String)"timeout");
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
        return this;
    }

    public EventWaiterBuilder<T> addPrecondition(Predicate<T> precondition) {
        Checks.notNull(precondition, (String)"Event waiter precondition");
        this.preconditions.add(precondition);
        return this;
    }

    public EventWaiterBuilder<T> setOnSuccess(Consumer<T> onSuccess) {
        this.onSuccess = onSuccess;
        return this;
    }

    public EventWaiterBuilder<T> setOnTimeout(Runnable onTimeout) {
        this.onTimeout = onTimeout;
        return this;
    }

    public EventWaiterBuilder<T> setOnCancelled(Runnable onCancelled) {
        this.onCancelled = onCancelled;
        return this;
    }

    public EventWaiterBuilder<T> setOnComplete(CompletedFutureEvent<T> onComplete) {
        this.onComplete = onComplete;
        return this;
    }

    public CompletableFuture<T> submit() {
        return EventWaiter.submit(new WaitingEvent<T>(this.eventType, this.preconditions, this.onComplete, this.onSuccess, this.onTimeout, this.onCancelled, this.timeout, this.timeoutUnit));
    }

    public T complete() throws CancellationException, ExecutionException, InterruptedException {
        return (T)((GenericEvent)this.submit().get());
    }
}

