/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.application.CommandPath;
import com.freya02.botcommands.api.application.annotations.AppOption;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.utils.LocalizationUtils;
import java.lang.reflect.Parameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationOptionData {
    private final String effectiveName;
    private final String effectiveDescription;
    private final String autocompletionHandlerName;

    public ApplicationOptionData(BContext context, CommandPath path, Parameter parameter) {
        AppOption option = parameter.getAnnotation(AppOption.class);
        this.effectiveName = option.name().isBlank() ? ApplicationOptionData.getOptionName(parameter) : option.name();
        this.effectiveDescription = this.getEffectiveDescription(context, path, option);
        this.autocompletionHandlerName = option.autocomplete().isBlank() ? null : option.autocomplete();
    }

    @NotNull
    private String getEffectiveDescription(@NotNull BContext context, CommandPath path, @NotNull AppOption option) {
        if (path != null) {
            String joinedPath = path.getFullPath('.');
            String rootLocalization = LocalizationUtils.getCommandRootLocalization((BContextImpl)context, "%s.options.%s.description".formatted(joinedPath, this.effectiveName));
            if (rootLocalization != null) {
                return rootLocalization;
            }
        }
        if (option.description().isBlank()) {
            return "No description";
        }
        return option.description();
    }

    private static String getOptionName(Parameter parameter) {
        if (!parameter.isNamePresent()) {
            throw new RuntimeException("Parameter name cannot be deduced as the option's name is not specified on: " + parameter);
        }
        String name = parameter.getName();
        int nameLength = name.length();
        StringBuilder optionNameBuilder = new StringBuilder(nameLength + 10);
        for (int i = 0; i < nameLength; ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                optionNameBuilder.append('_').append(Character.toLowerCase(c));
                continue;
            }
            optionNameBuilder.append(c);
        }
        return optionNameBuilder.toString();
    }

    @NotNull
    public String getEffectiveName() {
        return this.effectiveName;
    }

    @NotNull
    public String getEffectiveDescription() {
        return this.effectiveDescription;
    }

    public boolean hasAutocompletion() {
        return this.getAutocompletionHandlerName() != null;
    }

    @Nullable
    public String getAutocompletionHandlerName() {
        return this.autocompletionHandlerName;
    }
}

