/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.ConstructorParameterSupplier;
import com.freya02.botcommands.api.DefaultMessages;
import com.freya02.botcommands.api.DynamicInstanceSupplier;
import com.freya02.botcommands.api.ExceptionHandler;
import com.freya02.botcommands.api.InstanceSupplier;
import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.RegistrationListener;
import com.freya02.botcommands.api.SettingsProvider;
import com.freya02.botcommands.api.application.ApplicationCommandFilter;
import com.freya02.botcommands.api.application.CommandPath;
import com.freya02.botcommands.api.application.CommandUpdateResult;
import com.freya02.botcommands.api.application.slash.autocomplete.AutocompletionTransformer;
import com.freya02.botcommands.api.components.ComponentInteractionFilter;
import com.freya02.botcommands.api.components.ComponentManager;
import com.freya02.botcommands.api.parameters.CustomResolver;
import com.freya02.botcommands.api.parameters.CustomResolverFunction;
import com.freya02.botcommands.api.parameters.ParameterResolvers;
import com.freya02.botcommands.api.prefixed.HelpBuilderConsumer;
import com.freya02.botcommands.api.prefixed.TextCommandFilter;
import com.freya02.botcommands.internal.AbstractCommandInfo;
import com.freya02.botcommands.internal.LocalizationManager;
import com.freya02.botcommands.internal.application.ApplicationCommandInfo;
import com.freya02.botcommands.internal.application.ApplicationCommandsBuilder;
import com.freya02.botcommands.internal.application.ApplicationCommandsCache;
import com.freya02.botcommands.internal.application.ApplicationCommandsContextImpl;
import com.freya02.botcommands.internal.application.CommandInfoMap;
import com.freya02.botcommands.internal.application.context.message.MessageCommandInfo;
import com.freya02.botcommands.internal.application.context.user.UserCommandInfo;
import com.freya02.botcommands.internal.application.slash.SlashCommandInfo;
import com.freya02.botcommands.internal.application.slash.autocomplete.AutocompletionHandlerInfo;
import com.freya02.botcommands.internal.modals.ModalMaps;
import com.freya02.botcommands.internal.prefixed.TextCommandCandidates;
import com.freya02.botcommands.internal.prefixed.TextCommandInfo;
import com.freya02.botcommands.internal.prefixed.TextSubcommandCandidates;
import com.freya02.botcommands.internal.runner.JavaMethodRunnerFactory;
import com.freya02.botcommands.internal.runner.MethodRunnerFactory;
import com.freya02.botcommands.internal.utils.Utils;
import gnu.trove.TCollections;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.exceptions.ErrorHandler;
import net.dv8tion.jda.api.interactions.DiscordLocale;
import net.dv8tion.jda.api.requests.ErrorResponse;
import net.dv8tion.jda.internal.utils.Checks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import org.slf4j.Logger;

public class BContextImpl
implements BContext {
    private static final Logger LOGGER = Logging.getLogger();
    private final ApplicationCommandsContextImpl applicationCommandsContext = new ApplicationCommandsContextImpl();
    private final List<Long> ownerIds = new ArrayList<Long>();
    private final List<String> prefixes = new ArrayList<String>();
    private final Map<Class<?>, ConstructorParameterSupplier<?>> parameterSupplierMap = new HashMap();
    private final Map<Class<?>, InstanceSupplier<?>> instanceSupplierMap = new HashMap();
    private final List<DynamicInstanceSupplier> dynamicInstanceSuppliers = new ArrayList<DynamicInstanceSupplier>();
    private final Map<Class<?>, Supplier<?>> commandDependencyMap = new HashMap();
    private final Map<Class<?>, Object> classToObjMap = new HashMap();
    private final Map<CommandPath, TextCommandCandidates> textCommandMap = new HashMap<CommandPath, TextCommandCandidates>();
    private final Map<CommandPath, TextSubcommandCandidates> textSubcommandsMap = new HashMap<CommandPath, TextSubcommandCandidates>();
    private final ModalMaps modalMaps = new ModalMaps();
    private boolean onlineAppCommandCheckEnabled;
    private final Map<String, AutocompletionHandlerInfo> autocompleteHandlersMap = new HashMap<String, AutocompletionHandlerInfo>();
    private final TLongSet testGuildIds = TCollections.synchronizedSet((TLongSet)new TLongHashSet());
    private final List<TextCommandFilter> textFilters = new ArrayList<TextCommandFilter>();
    private final List<ApplicationCommandFilter> applicationFilters = new ArrayList<ApplicationCommandFilter>();
    private final List<ComponentInteractionFilter> componentFilters = new ArrayList<ComponentInteractionFilter>();
    private JDA jda;
    private Supplier<EmbedBuilder> defaultEmbedSupplier = EmbedBuilder::new;
    private Supplier<InputStream> defaultFooterIconSupplier = () -> null;
    private boolean isHelpDisabled;
    private boolean disableSuggestions = true;
    private ComponentManager componentManager;
    private SettingsProvider settingProvider;
    private final List<RegistrationListener> registrationListeners = new ArrayList<RegistrationListener>();
    private HelpBuilderConsumer helpBuilderConsumer;
    private ApplicationCommandsBuilder slashCommandsBuilder;
    private ApplicationCommandsCache applicationCommandsCache;
    private Function<@NotNull DiscordLocale, @NotNull DefaultMessages> defaultMessageProvider;
    private ExceptionHandler uncaughtExceptionHandler;
    private final Map<Class<?>, AutocompletionTransformer<?>> autocompletionTransformers = new HashMap();
    private long nextExceptionDispatch = 0L;
    private MethodRunnerFactory methodRunnerFactory = new JavaMethodRunnerFactory();
    private final LocalizationManager localizationManager = new LocalizationManager();

    @Override
    @NotNull
    public JDA getJDA() {
        return this.jda;
    }

    @Override
    public MethodRunnerFactory getMethodRunnerFactory() {
        return this.methodRunnerFactory;
    }

    public void setMethodRunnerFactory(@NotNull MethodRunnerFactory methodRunnerFactory) {
        this.methodRunnerFactory = methodRunnerFactory;
    }

    public void setJDA(JDA jda) {
        this.jda = jda;
    }

    @Override
    @NotNull
    public List<String> getPrefixes() {
        return this.prefixes;
    }

    @Override
    public void addPrefix(String prefix) {
        this.prefixes.add(prefix);
    }

    @Override
    @NotNull
    public List<Long> getOwnerIds() {
        return this.ownerIds;
    }

    @Override
    @NotNull
    public DefaultMessages getDefaultMessages(@NotNull DiscordLocale locale) {
        return this.defaultMessageProvider.apply(locale);
    }

    public void setDefaultMessageProvider(@NotNull @NotNull Function<@NotNull DiscordLocale, @NotNull DefaultMessages> defaultMessageProvider) {
        this.defaultMessageProvider = defaultMessageProvider;
    }

    @Override
    @Nullable
    public TextCommandInfo findFirstCommand(@NotNull CommandPath path) {
        TextCommandCandidates candidates = this.textCommandMap.get(path);
        if (candidates == null) {
            return null;
        }
        return candidates.findFirst();
    }

    @Override
    @Nullable
    public TextCommandCandidates findCommands(@NotNull CommandPath path) {
        return this.textCommandMap.get(path);
    }

    @Override
    @Nullable
    public TextCommandCandidates findFirstTextSubcommands(CommandPath path) {
        List list = Objects.requireNonNullElseGet((List)this.textSubcommandsMap.get(path), Collections::emptyList);
        if (list.isEmpty()) {
            return null;
        }
        return (TextCommandCandidates)list.get(0);
    }

    @Override
    @Nullable
    public List<TextCommandCandidates> findTextSubcommands(CommandPath path) {
        return this.textSubcommandsMap.get(path);
    }

    @Override
    @NotNull
    public ApplicationCommandsContextImpl getApplicationCommandsContext() {
        return this.applicationCommandsContext;
    }

    @Override
    @NotNull
    public Supplier<EmbedBuilder> getDefaultEmbedSupplier() {
        return this.defaultEmbedSupplier;
    }

    public void setDefaultEmbedSupplier(Supplier<EmbedBuilder> defaultEmbedSupplier) {
        this.defaultEmbedSupplier = Objects.requireNonNull(defaultEmbedSupplier, "Default embed supplier cannot be null");
    }

    @Override
    @NotNull
    public Supplier<InputStream> getDefaultFooterIconSupplier() {
        return this.defaultFooterIconSupplier;
    }

    public void addOwner(long ownerId) {
        this.ownerIds.add(ownerId);
    }

    public void setDefaultFooterIconSupplier(Supplier<InputStream> defaultFooterIconSupplier) {
        this.defaultFooterIconSupplier = Objects.requireNonNull(defaultFooterIconSupplier, "Default footer icon supplier cannot be null");
    }

    public void addTextCommand(TextCommandInfo commandInfo) {
        CommandPath path = commandInfo.getPath();
        List<CommandPath> aliases = commandInfo.getAliases();
        this.textCommandMap.compute(path, (k, v) -> {
            if (v == null) {
                return new TextCommandCandidates(commandInfo);
            }
            v.add(commandInfo);
            return v;
        });
        CommandPath parentPath = path.getParent();
        if (parentPath != null) {
            this.textSubcommandsMap.compute(parentPath, (x, candidates) -> candidates == null ? new TextSubcommandCandidates(commandInfo) : candidates.addSubcommand(commandInfo));
        }
        for (CommandPath alias : aliases) {
            this.textCommandMap.compute(alias, (k, v) -> {
                if (v == null) {
                    return new TextCommandCandidates(commandInfo);
                }
                v.add(commandInfo);
                return v;
            });
        }
    }

    @NotNull
    private CommandPath getEffectivePath(@NotNull AbstractCommandInfo<?> commandInfo) {
        return commandInfo.getCommandId() == null ? commandInfo.getPath() : CommandPath.ofName(commandInfo.getCommandId());
    }

    public CommandPath addSlashCommand(SlashCommandInfo commandInfo) {
        CommandPath path = this.getEffectivePath(commandInfo);
        CommandInfoMap<SlashCommandInfo> slashCommandMap = this.getApplicationCommandsContext().getSlashCommandsMap();
        slashCommandMap.put(path, commandInfo);
        return path;
    }

    public CommandPath addUserCommand(UserCommandInfo commandInfo) {
        CommandPath path = this.getEffectivePath(commandInfo);
        UserCommandInfo oldCmd = this.getApplicationCommandsContext().getUserCommandsMap().put(path, commandInfo);
        if (oldCmd != null) {
            throw new IllegalStateException(String.format("Two user commands have the same names: '%s' from %s and %s", path, Utils.formatMethodShort(oldCmd.getMethod()), Utils.formatMethodShort(commandInfo.getMethod())));
        }
        return path;
    }

    public CommandPath addMessageCommand(MessageCommandInfo commandInfo) {
        CommandPath path = this.getEffectivePath(commandInfo);
        MessageCommandInfo oldCmd = this.getApplicationCommandsContext().getMessageCommandsMap().put(path, commandInfo);
        if (oldCmd != null) {
            throw new IllegalStateException(String.format("Two message commands have the same names: '%s' from %s and %s", path, Utils.formatMethodShort(oldCmd.getMethod()), Utils.formatMethodShort(commandInfo.getMethod())));
        }
        return path;
    }

    public void addAutocompletionHandler(AutocompletionHandlerInfo handlerInfo) {
        AutocompletionHandlerInfo oldHandler = this.autocompleteHandlersMap.put(handlerInfo.getHandlerName(), handlerInfo);
        if (oldHandler != null) {
            throw new IllegalArgumentException("Tried to register autocompletion handler '" + handlerInfo.getHandlerName() + "' at " + Utils.formatMethodShort(handlerInfo.getMethod()) + " was already registered at " + Utils.formatMethodShort(oldHandler.getMethod()));
        }
    }

    @Nullable
    public AutocompletionHandlerInfo getAutocompletionHandler(String autocompletionHandlerName) {
        return this.autocompleteHandlersMap.get(autocompletionHandlerName);
    }

    @Override
    public void invalidateAutocompletionCache(String autocompletionHandlerName) {
        AutocompletionHandlerInfo handler = this.getAutocompletionHandler(autocompletionHandlerName);
        if (handler == null) {
            throw new IllegalArgumentException("Autocompletion handler name not found for '" + autocompletionHandlerName + "'");
        }
        handler.invalidate();
    }

    public Collection<TextCommandCandidates> getCommands() {
        return Collections.unmodifiableCollection(this.textCommandMap.values());
    }

    public @UnmodifiableView Collection<? extends ApplicationCommandInfo> getApplicationCommandsView() {
        return this.getApplicationCommandsContext().getApplicationCommandInfoMap().getAllApplicationCommandsView();
    }

    @Override
    public void dispatchException(@NotNull String message, @Nullable Throwable t) {
        if (this.nextExceptionDispatch < System.currentTimeMillis()) {
            this.nextExceptionDispatch = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(10L);
            String exceptionStr = t == null ? "" : "\nException : \n%s".formatted(Utils.getException(t));
            this.jda.retrieveApplicationInfo().map(applicationInfo -> {
                if (applicationInfo.getTeam() != null) {
                    return applicationInfo.getTeam().getOwnerIdLong();
                }
                return applicationInfo.getOwner().getIdLong();
            }).flatMap(arg_0 -> ((JDA)this.jda).openPrivateChannelById(arg_0)).flatMap(channel -> channel.sendMessage((CharSequence)"%s%s\n\nPlease check the logs for more detail and possible exceptions".formatted(message, exceptionStr))).queue(null, (Consumer)new ErrorHandler().handle(ErrorResponse.CANNOT_SEND_TO_USER, x -> LOGGER.warn("Could not send exception DM to owner")));
        }
    }

    @Override
    public void addTextFilter(TextCommandFilter filter) {
        Checks.notNull((Object)filter, (String)"Text command filter");
        this.textFilters.add(filter);
    }

    @Override
    public void addApplicationFilter(ApplicationCommandFilter filter) {
        Checks.notNull((Object)filter, (String)"Application command filter");
        this.applicationFilters.add(filter);
    }

    @Override
    public void addComponentFilter(ComponentInteractionFilter filter) {
        Checks.notNull((Object)filter, (String)"Component interaction filter");
        this.componentFilters.add(filter);
    }

    @Override
    public void removeTextFilter(TextCommandFilter filter) {
        Checks.notNull((Object)filter, (String)"Text command filter");
        this.textFilters.remove(filter);
    }

    @Override
    public void removeApplicationFilter(ApplicationCommandFilter filter) {
        Checks.notNull((Object)filter, (String)"Application command filter");
        this.applicationFilters.remove(filter);
    }

    @Override
    public void removeComponentFilter(ComponentInteractionFilter filter) {
        Checks.notNull((Object)filter, (String)"Component interaction filter");
        this.componentFilters.remove(filter);
    }

    public List<TextCommandFilter> getTextFilters() {
        return this.textFilters;
    }

    public List<ApplicationCommandFilter> getApplicationFilters() {
        return this.applicationFilters;
    }

    public List<ComponentInteractionFilter> getComponentFilters() {
        return this.componentFilters;
    }

    public void disableHelp(boolean isHelpDisabled) {
        this.isHelpDisabled = isHelpDisabled;
    }

    public void disableSuggestions(boolean disableSuggestions) {
        this.disableSuggestions = disableSuggestions;
    }

    @Override
    public List<RegistrationListener> getRegistrationListeners() {
        return Collections.unmodifiableList(this.registrationListeners);
    }

    @Override
    public void addRegistrationListeners(RegistrationListener ... listeners) {
        Collections.addAll(this.registrationListeners, listeners);
    }

    @Override
    @Nullable
    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public void setComponentManager(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    public Object getClassInstance(Class<?> clazz) {
        return this.classToObjMap.get(clazz);
    }

    public void putClassInstance(Class<?> clazz, Object obj) {
        this.classToObjMap.put(clazz, obj);
    }

    public void addEventListeners(Object ... listeners) {
        if (this.jda.getShardManager() != null) {
            this.jda.getShardManager().addEventListener(listeners);
        } else {
            this.jda.addEventListener(listeners);
        }
    }

    public void setSettingsProvider(SettingsProvider settingsProvider) {
        this.settingProvider = settingsProvider;
    }

    @Override
    @Nullable
    public SettingsProvider getSettingsProvider() {
        return this.settingProvider;
    }

    public void setHelpBuilderConsumer(HelpBuilderConsumer builderConsumer) {
        this.helpBuilderConsumer = builderConsumer;
    }

    @Override
    public HelpBuilderConsumer getHelpBuilderConsumer() {
        return this.helpBuilderConsumer;
    }

    public void setSlashCommandsBuilder(ApplicationCommandsBuilder slashCommandsBuilder) {
        this.slashCommandsBuilder = slashCommandsBuilder;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> scheduleGlobalApplicationCommandsUpdate(boolean force, boolean onlineCheck) {
        return this.slashCommandsBuilder.scheduleGlobalApplicationCommandsUpdate(force, onlineCheck);
    }

    @Override
    @NotNull
    public Map<Guild, CompletableFuture<CommandUpdateResult>> scheduleApplicationCommandsUpdate(Iterable<Guild> guilds, boolean force, boolean onlineCheck) {
        return this.slashCommandsBuilder.scheduleApplicationCommandsUpdate(guilds, false, onlineCheck);
    }

    @Override
    @NotNull
    public CompletableFuture<CommandUpdateResult> scheduleApplicationCommandsUpdate(Guild guild, boolean force, boolean onlineCheck) {
        return this.slashCommandsBuilder.scheduleApplicationCommandsUpdate(guild, force, onlineCheck);
    }

    public ApplicationCommandsBuilder getSlashCommandsBuilder() {
        return this.slashCommandsBuilder;
    }

    @Override
    public <T> void registerCustomResolver(Class<T> parameterType, CustomResolverFunction<T> function) {
        ParameterResolvers.register(new CustomResolver(parameterType, function));
    }

    public <T> void registerConstructorParameter(Class<T> parameterType, ConstructorParameterSupplier<T> parameterSupplier) {
        this.parameterSupplierMap.put(parameterType, parameterSupplier);
    }

    public <T> void registerInstanceSupplier(Class<T> classType, InstanceSupplier<T> instanceSupplier) {
        this.instanceSupplierMap.put(classType, instanceSupplier);
    }

    public void registerDynamicInstanceSupplier(DynamicInstanceSupplier dynamicInstanceSupplier) {
        this.dynamicInstanceSuppliers.add(dynamicInstanceSupplier);
    }

    public ConstructorParameterSupplier<?> getParameterSupplier(Class<?> parameterType) {
        return this.parameterSupplierMap.get(parameterType);
    }

    public InstanceSupplier<?> getInstanceSupplier(Class<?> classType) {
        return this.instanceSupplierMap.get(classType);
    }

    public List<DynamicInstanceSupplier> getDynamicInstanceSuppliers() {
        return this.dynamicInstanceSuppliers;
    }

    public <T> void registerCommandDependency(Class<T> fieldType, Supplier<T> supplier) {
        this.commandDependencyMap.put(fieldType, supplier);
    }

    public Supplier<?> getCommandDependency(Class<?> fieldType) {
        return this.commandDependencyMap.get(fieldType);
    }

    public ApplicationCommandsCache getApplicationCommandsCache() {
        return this.applicationCommandsCache;
    }

    public void setApplicationCommandsCache(ApplicationCommandsCache cachedSlashCommands) {
        this.applicationCommandsCache = cachedSlashCommands;
    }

    public boolean isHelpDisabled() {
        return this.isHelpDisabled;
    }

    public boolean areSuggestionsDisabled() {
        return this.disableSuggestions;
    }

    public void setUncaughtExceptionHandler(@Nullable ExceptionHandler exceptionHandler) {
        this.uncaughtExceptionHandler = exceptionHandler;
    }

    @Override
    @Nullable
    public ExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    @Override
    public TLongSet getTestGuildIds() {
        return this.testGuildIds;
    }

    public void addTestGuildIds(long ... ids) {
        this.testGuildIds.addAll(ids);
    }

    public AutocompletionTransformer<?> getAutocompletionTransformer(Class<?> type) {
        return this.autocompletionTransformers.get(type);
    }

    public <T> void registerAutocompletionTransformer(Class<T> type, AutocompletionTransformer<T> autocompletionTransformer) {
        this.autocompletionTransformers.put(type, autocompletionTransformer);
    }

    public boolean isOnlineAppCommandCheckEnabled() {
        return this.onlineAppCommandCheckEnabled;
    }

    public void enableOnlineAppCommandCheck() {
        this.onlineAppCommandCheckEnabled = true;
    }

    public ModalMaps getModalMaps() {
        return this.modalMaps;
    }

    public LocalizationManager getLocalizationManager() {
        return this.localizationManager;
    }
}

