/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.DefaultMessages;
import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.RegistrationListener;
import com.freya02.botcommands.api.annotations.JDAEventListener;
import com.freya02.botcommands.api.application.ApplicationCommand;
import com.freya02.botcommands.api.application.CommandPath;
import com.freya02.botcommands.api.application.context.annotations.JDAMessageCommand;
import com.freya02.botcommands.api.application.context.annotations.JDAUserCommand;
import com.freya02.botcommands.api.application.slash.annotations.JDASlashCommand;
import com.freya02.botcommands.api.application.slash.autocomplete.annotations.AutocompletionHandler;
import com.freya02.botcommands.api.modals.annotations.ModalHandler;
import com.freya02.botcommands.api.prefixed.TextCommand;
import com.freya02.botcommands.api.prefixed.annotations.JDATextCommand;
import com.freya02.botcommands.api.waiter.EventWaiter;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.ConflictDetector;
import com.freya02.botcommands.internal.Version;
import com.freya02.botcommands.internal.application.ApplicationCommandListener;
import com.freya02.botcommands.internal.application.ApplicationCommandsBuilder;
import com.freya02.botcommands.internal.application.ApplicationUpdaterListener;
import com.freya02.botcommands.internal.application.slash.autocomplete.AutocompletionHandlersBuilder;
import com.freya02.botcommands.internal.components.ComponentsBuilder;
import com.freya02.botcommands.internal.events.EventListenersBuilder;
import com.freya02.botcommands.internal.modals.ModalHandlersBuilder;
import com.freya02.botcommands.internal.prefixed.CommandListener;
import com.freya02.botcommands.internal.prefixed.HelpCommand;
import com.freya02.botcommands.internal.prefixed.PrefixedCommandsBuilder;
import com.freya02.botcommands.internal.utils.ClassInstancer;
import com.freya02.botcommands.internal.utils.ReflectionUtils;
import com.freya02.botcommands.internal.utils.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.interactions.DiscordLocale;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.sharding.ShardManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class CommandsBuilderImpl {
    private static final Logger LOGGER = Logging.getLogger();
    private static final List<Class<? extends Annotation>> applicationMethodAnnotations = List.of(JDASlashCommand.class, JDAMessageCommand.class, JDAUserCommand.class);
    private final PrefixedCommandsBuilder prefixedCommandsBuilder;
    private final EventListenersBuilder eventListenersBuilder;
    private final ApplicationCommandsBuilder applicationCommandsBuilder;
    private final AutocompletionHandlersBuilder autocompletionHandlersBuilder;
    private final ModalHandlersBuilder modalHandlersBuilder;
    private final ComponentsBuilder componentsBuilder;
    private final BContextImpl context;
    private final Set<Class<?>> classes;
    private final boolean usePing;
    private final List<Class<?>> ignoredClasses = new ArrayList();

    public CommandsBuilderImpl(BContextImpl context, Set<String> packageNames, Set<Class<?>> manualClasses, List<Long> slashGuildIds) {
        this.context = context;
        this.classes = ReflectionUtils.scanPackagesAndClasses(packageNames, manualClasses);
        this.prefixedCommandsBuilder = new PrefixedCommandsBuilder(context);
        this.componentsBuilder = new ComponentsBuilder(context);
        this.usePing = context.getPrefixes().isEmpty();
        if (this.usePing) {
            LOGGER.info("No prefix has been set, using bot ping as prefix");
        }
        this.applicationCommandsBuilder = new ApplicationCommandsBuilder(context, slashGuildIds);
        this.eventListenersBuilder = new EventListenersBuilder(context);
        this.autocompletionHandlersBuilder = new AutocompletionHandlersBuilder(context);
        this.modalHandlersBuilder = new ModalHandlersBuilder(context);
    }

    private void buildClasses() throws Exception {
        for (Class<?> aClass : this.classes) {
            this.processClass(aClass);
        }
        if (this.context.findFirstCommand(CommandPath.ofName("help")) == null) {
            if (this.context.isHelpDisabled()) {
                LOGGER.debug("Using no 'help' text command implementation");
            } else {
                this.processClass(HelpCommand.class);
            }
        } else {
            LOGGER.debug("Using a custom 'help' text command implementation");
        }
        this.prefixedCommandsBuilder.postProcess();
        if (this.context.getComponentManager() != null) {
            for (Class<?> aClass : this.classes) {
                this.componentsBuilder.processClass(aClass);
            }
        } else {
            LOGGER.info("ComponentManager is not set, the Components API, paginators and menus won't be usable");
        }
        this.applicationCommandsBuilder.postProcess();
        if (this.context.getComponentManager() != null) {
            this.componentsBuilder.postProcess();
        }
        this.eventListenersBuilder.postProcess();
        this.autocompletionHandlersBuilder.postProcess();
        this.modalHandlersBuilder.postProcess();
        this.context.getRegistrationListeners().forEach(RegistrationListener::onBuildComplete);
        LOGGER.info("Finished registering all commands");
    }

    private void processClass(Class<?> aClass) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        if (!Modifier.isAbstract(aClass.getModifiers()) && !Modifier.isInterface(aClass.getModifiers())) {
            boolean foundSomething = false;
            for (Method method : aClass.getDeclaredMethods()) {
                foundSomething |= this.processMethod(method);
            }
            if (!foundSomething) {
                this.ignoredClasses.add(aClass);
            }
        }
    }

    @Nullable
    private <T> T tryInstantiateMethod(@NotNull Class<? extends Annotation> requiredAnnotation, @NotNull Class<T> requiredClass, @NotNull String requiredClassDesc, @NotNull Method method) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?> declaringClass = method.getDeclaringClass();
        if (method.isAnnotationPresent(requiredAnnotation)) {
            if (!requiredClass.isAssignableFrom(declaringClass)) {
                throw new IllegalArgumentException("Method " + Utils.formatMethodShort(method) + " is annotated with @" + requiredAnnotation.getSimpleName() + " but its class does not extend " + requiredClass.getSimpleName());
            }
            Object annotatedInstance = ClassInstancer.instantiate(this.context, declaringClass);
            if (!method.canAccess(annotatedInstance)) {
                throw new IllegalStateException(requiredClassDesc + " " + Utils.formatMethodShort(method) + " is not public");
            }
            if (Modifier.isStatic(method.getModifiers())) {
                throw new IllegalStateException(requiredClassDesc + " " + Utils.formatMethodShort(method) + " is static");
            }
            return (T)annotatedInstance;
        }
        return null;
    }

    private boolean processMethod(Method method) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        for (Class<? extends Annotation> annotation : applicationMethodAnnotations) {
            ApplicationCommand applicationCommand = this.tryInstantiateMethod(annotation, ApplicationCommand.class, "Application command", method);
            if (applicationCommand == null) continue;
            this.applicationCommandsBuilder.processApplicationCommand(applicationCommand, method);
            return true;
        }
        TextCommand textCommand = this.tryInstantiateMethod(JDATextCommand.class, TextCommand.class, "Text command", method);
        if (textCommand != null) {
            this.prefixedCommandsBuilder.processPrefixedCommand(textCommand, method);
            return true;
        }
        Object eventListener = this.tryInstantiateMethod(JDAEventListener.class, Object.class, "JDA event listener", method);
        if (eventListener != null) {
            this.eventListenersBuilder.processEventListener(eventListener, method);
            return true;
        }
        Object autocompletionHandler = this.tryInstantiateMethod(AutocompletionHandler.class, Object.class, "Slash command auto completion", method);
        if (autocompletionHandler != null) {
            this.autocompletionHandlersBuilder.processHandler(autocompletionHandler, method);
            return true;
        }
        Object modalHandler = this.tryInstantiateMethod(ModalHandler.class, Object.class, "Modal handler", method);
        if (modalHandler != null) {
            this.modalHandlersBuilder.processHandler(modalHandler, method);
            return true;
        }
        return false;
    }

    public void build(JDA jda) throws Exception {
        Version.checkVersions();
        if (jda.getShardInfo().getShardId() != 0) {
            LOGGER.warn("A shard other than 0 was passed to CommandsBuilder#build, shard 0 is needed to handle DMing exceptions, manually retrieving shard 0...");
            ShardManager manager = jda.getShardManager();
            if (manager == null) {
                throw new IllegalArgumentException("Unable to retrieve Shard 0 as shard manager is null");
            }
            jda = manager.getShardById(0);
            if (jda == null) {
                throw new IllegalArgumentException("Unable to retrieve Shard 0");
            }
        }
        if (jda.getStatus() != JDA.Status.CONNECTED) {
            try {
                LOGGER.warn("JDA should already be ready when you call #build on CommandsBuilder !");
                jda.awaitReady();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("CommandsBuilder got interrupted while waiting for JDA to be ready", e);
            }
        }
        this.setupContext(jda);
        this.buildClasses();
        if (jda.getGatewayIntents().contains(GatewayIntent.GUILD_MESSAGES)) {
            if (jda.getGatewayIntents().contains(GatewayIntent.MESSAGE_CONTENT) || this.usePing) {
                this.context.addEventListeners(new Object[]{new CommandListener(this.context, this.usePing)});
            } else {
                LOGGER.info("Text commands will not work as the MESSAGE_CONTENT intent is missing and ping-as-prefix is not enabled");
            }
        } else {
            LOGGER.info("Text commands will not work as the GUILD_MESSAGES intent is missing");
        }
        this.context.addEventListeners(new Object[]{new EventWaiter(jda), new ApplicationUpdaterListener(this.context), new ApplicationCommandListener(this.context)});
        if (!this.ignoredClasses.isEmpty()) {
            LOGGER.trace("Ignored classes in search paths:");
            for (Class<?> ignoredClass : this.ignoredClasses) {
                LOGGER.trace("\t{}", (Object)ignoredClass.getName());
            }
        }
        ConflictDetector.detectConflicts();
    }

    private void setupContext(JDA jda) {
        if (this.context.getOwnerIds().isEmpty()) {
            LOGGER.info("No owner ID specified, exceptions won't be sent to owners");
        }
        this.context.setJDA(jda);
        if (this.usePing) {
            this.context.addPrefix("<@" + jda.getSelfUser().getId() + "> ");
            this.context.addPrefix("<@!" + jda.getSelfUser().getId() + "> ");
        }
        this.context.registerConstructorParameter(BContext.class, ignored -> this.context);
        this.context.registerCommandDependency(BContext.class, () -> this.context);
        this.context.registerCustomResolver(BContext.class, (x, y, ignored) -> this.context);
        this.context.registerConstructorParameter(JDA.class, ignored -> jda);
        this.context.registerCommandDependency(JDA.class, () -> jda);
        this.context.registerCustomResolver(JDA.class, (x, y, ignored) -> jda);
        this.context.setDefaultMessageProvider(new DefaultMessagesFunction());
    }

    private static class DefaultMessagesFunction
    implements Function<DiscordLocale, DefaultMessages> {
        private final Map<DiscordLocale, DefaultMessages> localeDefaultMessagesMap = new HashMap<DiscordLocale, DefaultMessages>();

        private DefaultMessagesFunction() {
        }

        @Override
        public DefaultMessages apply(@NotNull DiscordLocale locale) {
            return this.localeDefaultMessagesMap.computeIfAbsent(locale, locale1 -> new DefaultMessages(Locale.forLanguageTag(locale.getLocale())));
        }
    }
}

