/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal;

import com.freya02.botcommands.api.CooldownScope;
import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.internal.CooldownStrategy;
import gnu.trove.TCollections;
import gnu.trove.map.TLongLongMap;
import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TLongLongHashMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.util.function.Supplier;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.interactions.Interaction;
import org.slf4j.Logger;

public abstract class Cooldownable {
    private static final Logger LOGGER = Logging.getLogger();
    private final CooldownStrategy cooldownStrategy;
    private final TObjectLongMap<UserGuild> userCooldowns = TCollections.synchronizedMap((TObjectLongMap)new TObjectLongHashMap(10, 0.5f, 0L));
    private final TLongLongMap channelCooldowns = TCollections.synchronizedMap((TLongLongMap)new TLongLongHashMap(10, 0.5f, 0L, 0L));
    private final TLongLongMap guildCooldowns = TCollections.synchronizedMap((TLongLongMap)new TLongLongHashMap(10, 0.5f, 0L, 0L));

    protected Cooldownable(CooldownStrategy cooldownStrategy) {
        this.cooldownStrategy = cooldownStrategy;
    }

    public long getCooldownMillis() {
        return this.cooldownStrategy.getCooldownMillis();
    }

    public CooldownScope getCooldownScope() {
        return this.cooldownStrategy.getScope();
    }

    public void applyCooldown(MessageReceivedEvent event) {
        switch (this.getCooldownScope()) {
            case USER: {
                this.userCooldowns.put((Object)this.getUGKey(event), System.currentTimeMillis() + this.getCooldownMillis());
                break;
            }
            case GUILD: {
                this.guildCooldowns.put(event.getGuild().getIdLong(), System.currentTimeMillis() + this.getCooldownMillis());
                break;
            }
            case CHANNEL: {
                this.channelCooldowns.put(event.getChannel().getIdLong(), System.currentTimeMillis() + this.getCooldownMillis());
            }
        }
    }

    private UserGuild getUGKey(MessageReceivedEvent event) {
        return new UserGuild(event.getGuild().getIdLong(), event.getAuthor().getIdLong());
    }

    private UserGuild getUGKey(Interaction event, Guild guild) {
        return new UserGuild(guild.getIdLong(), event.getUser().getIdLong());
    }

    public void applyCooldown(Interaction event) {
        switch (this.getCooldownScope()) {
            case USER: {
                if (event.getGuild() == null) break;
                this.userCooldowns.put((Object)this.getUGKey(event, event.getGuild()), System.currentTimeMillis() + this.getCooldownMillis());
                break;
            }
            case GUILD: {
                if (event.getGuild() == null) break;
                this.guildCooldowns.put(event.getGuild().getIdLong(), System.currentTimeMillis() + this.getCooldownMillis());
                break;
            }
            case CHANNEL: {
                if (event.getChannel() == null) break;
                this.channelCooldowns.put(event.getChannel().getIdLong(), System.currentTimeMillis() + this.getCooldownMillis());
            }
        }
    }

    public long getCooldown(MessageReceivedEvent event) {
        return switch (this.getCooldownScope()) {
            default -> throw new IncompatibleClassChangeError();
            case CooldownScope.USER -> Math.max(0L, this.userCooldowns.get((Object)this.getUGKey(event)) - System.currentTimeMillis());
            case CooldownScope.GUILD -> Math.max(0L, this.guildCooldowns.get(event.getGuild().getIdLong()) - System.currentTimeMillis());
            case CooldownScope.CHANNEL -> Math.max(0L, this.channelCooldowns.get(event.getChannel().getIdLong()) - System.currentTimeMillis());
        };
    }

    public long getCooldown(Interaction event, Supplier<String> cmdNameSupplier) {
        switch (this.getCooldownScope()) {
            case USER: {
                if (event.getGuild() == null) {
                    LOGGER.warn("Interaction command '{}' wasn't used in a guild but uses a guild-wide cooldown", (Object)cmdNameSupplier.get());
                    return 0L;
                }
                return Math.max(0L, this.userCooldowns.get((Object)this.getUGKey(event, event.getGuild())) - System.currentTimeMillis());
            }
            case GUILD: {
                if (event.getGuild() == null) {
                    LOGGER.warn("Interaction command '{}' wasn't used in a guild but uses a guild-wide cooldown", (Object)cmdNameSupplier.get());
                    return 0L;
                }
                return Math.max(0L, this.guildCooldowns.get(event.getGuild().getIdLong()) - System.currentTimeMillis());
            }
            case CHANNEL: {
                if (event.getChannel() == null) {
                    LOGGER.warn("Interaction command '{}' wasn't used in a channel, somehow", (Object)cmdNameSupplier.get());
                    return 0L;
                }
                return Math.max(0L, this.channelCooldowns.get(event.getChannel().getIdLong()) - System.currentTimeMillis());
            }
        }
        throw new IllegalStateException("Unexpected value: " + this.getCooldownScope());
    }

    private record UserGuild(long guildId, long userId) {
    }
}

