/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.annotations.NSFW;
import com.freya02.botcommands.api.application.ApplicationCommand;
import com.freya02.botcommands.api.application.CommandScope;
import com.freya02.botcommands.internal.AbstractCommandInfo;
import com.freya02.botcommands.internal.MethodParameters;
import com.freya02.botcommands.internal.application.ApplicationCommandParameter;
import com.freya02.botcommands.internal.utils.AnnotationUtils;
import com.freya02.botcommands.internal.utils.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public abstract class ApplicationCommandInfo
extends AbstractCommandInfo<ApplicationCommand> {
    protected final CommandScope scope;
    protected final boolean defaultLocked;
    protected final boolean guildOnly;
    protected final boolean testOnly;
    protected final boolean nsfw;

    @SafeVarargs
    protected <A extends Annotation> ApplicationCommandInfo(@NotNull BContext context, @NotNull ApplicationCommand instance, @NotNull A annotation, @NotNull Method commandMethod, Function<A, String> ... nameComponentsFunctions) {
        super(context, instance, annotation, commandMethod, nameComponentsFunctions);
        this.scope = (CommandScope)((Object)AnnotationUtils.getAnnotationValue(annotation, "scope"));
        this.defaultLocked = (Boolean)AnnotationUtils.getAnnotationValue(annotation, "defaultLocked");
        this.guildOnly = context.getApplicationCommandsContext().isForceGuildCommandsEnabled() || this.scope.isGuildOnly();
        this.testOnly = AnnotationUtils.getEffectiveTestState(commandMethod);
        this.nsfw = (Boolean)AnnotationUtils.getAnnotationValue(annotation, "nsfw");
        if (this.testOnly && this.scope != CommandScope.GUILD) {
            throw new IllegalArgumentException(Utils.formatMethodShort(commandMethod) + " : application command annotated with @Test must have the GUILD scope");
        }
        if (this.isOwnerRequired()) {
            throw new IllegalArgumentException(Utils.formatMethodShort(commandMethod) + " : application commands cannot be marked as owner-only");
        }
        if (commandMethod.isAnnotationPresent(NSFW.class)) {
            throw new IllegalArgumentException("@NSFW can only be used on text commands, use the #nsfw method on your annotation instead");
        }
        if (this.isDefaultLocked()) {
            this.userPermissions.clear();
        }
        if (!(this.userPermissions.size() == 0 && this.botPermissions.size() == 0 || this.guildOnly)) {
            throw new IllegalArgumentException(Utils.formatMethodShort(commandMethod) + " : application command with permissions should be guild-only");
        }
        if (this.getCommandId() != null && this.scope != CommandScope.GUILD) {
            throw new IllegalArgumentException(Utils.formatMethodShort(commandMethod) + " : application command with guild-specific ID must have the GUILD scope");
        }
    }

    public CommandScope getScope() {
        return this.scope;
    }

    public boolean isDefaultLocked() {
        return this.defaultLocked;
    }

    public boolean isGuildOnly() {
        return this.guildOnly;
    }

    public boolean isTestOnly() {
        return this.testOnly;
    }

    public boolean isNsfw() {
        return this.nsfw;
    }

    @NotNull
    public abstract MethodParameters<? extends ApplicationCommandParameter<?>> getParameters();

    @NotNull
    public List<? extends ApplicationCommandParameter<?>> getOptionParameters() {
        return super.getOptionParameters();
    }
}

