/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application;

import com.freya02.botcommands.api.CooldownScope;
import com.freya02.botcommands.api.DefaultMessages;
import com.freya02.botcommands.api.ExceptionHandler;
import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.application.ApplicationCommandFilter;
import com.freya02.botcommands.api.application.ApplicationCommandInfoMapView;
import com.freya02.botcommands.api.application.ApplicationFilteringData;
import com.freya02.botcommands.api.application.CommandPath;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.RunnableEx;
import com.freya02.botcommands.internal.Usability;
import com.freya02.botcommands.internal.application.ApplicationCommandInfo;
import com.freya02.botcommands.internal.application.context.message.MessageCommandInfo;
import com.freya02.botcommands.internal.application.context.user.UserCommandInfo;
import com.freya02.botcommands.internal.application.slash.SlashCommandInfo;
import com.freya02.botcommands.internal.utils.Utils;
import java.util.EnumSet;
import java.util.StringJoiner;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.api.events.interaction.command.GenericCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.MessageContextInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.UserContextInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.hooks.SubscribeEvent;
import net.dv8tion.jda.api.interactions.Interaction;
import net.dv8tion.jda.api.interactions.commands.CommandInteraction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class ApplicationCommandListener
extends ListenerAdapter {
    private static final Logger LOGGER = Logging.getLogger();
    private final BContextImpl context;
    private int commandThreadNumber = 0;
    private final ExecutorService commandService = Utils.createCommandPool(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(false);
        thread.setUncaughtExceptionHandler((t, e) -> Utils.printExceptionString("An unexpected exception happened in an application command thread '" + t.getName() + "':", e));
        thread.setName("Application command thread #" + this.commandThreadNumber++);
        return thread;
    });

    public ApplicationCommandListener(BContextImpl context) {
        this.context = context;
    }

    @SubscribeEvent
    public void onUserContextInteraction(@NotNull UserContextInteractionEvent event) {
        LOGGER.trace("Received user command: {}", (Object)event.getName());
        Consumer<Throwable> throwableConsumer = this.getThrowableConsumer((GenericCommandInteractionEvent)event);
        this.runCommand(() -> {
            UserCommandInfo userCommand = this.context.getApplicationCommandsContext().findLiveUserCommand(event.getGuild(), event.getName());
            if (userCommand == null) {
                throwableConsumer.accept(new IllegalArgumentException("An user context command could not be found: " + event.getName()));
                this.printAvailableCommands((GenericCommandInteractionEvent)event);
                return;
            }
            if (!this.canRun((GenericCommandInteractionEvent)event, userCommand)) {
                return;
            }
            userCommand.execute(this.context, event, throwableConsumer);
        }, throwableConsumer);
    }

    @SubscribeEvent
    public void onMessageContextInteraction(@NotNull MessageContextInteractionEvent event) {
        LOGGER.trace("Received message command: {}", (Object)event.getName());
        Consumer<Throwable> throwableConsumer = this.getThrowableConsumer((GenericCommandInteractionEvent)event);
        this.runCommand(() -> {
            MessageCommandInfo messageCommand = this.context.getApplicationCommandsContext().findLiveMessageCommand(event.getGuild(), event.getName());
            if (messageCommand == null) {
                throwableConsumer.accept(new IllegalArgumentException("A message context command could not be found: " + event.getName()));
                this.printAvailableCommands((GenericCommandInteractionEvent)event);
                return;
            }
            if (!this.canRun((GenericCommandInteractionEvent)event, messageCommand)) {
                return;
            }
            messageCommand.execute(this.context, event, throwableConsumer);
        }, throwableConsumer);
    }

    @SubscribeEvent
    public void onSlashCommandInteraction(@NotNull SlashCommandInteractionEvent event) {
        LOGGER.trace("Received slash command: {}", (Object)ApplicationCommandListener.reconstructCommand((GenericCommandInteractionEvent)event));
        Consumer<Throwable> throwableConsumer = this.getThrowableConsumer((GenericCommandInteractionEvent)event);
        this.runCommand(() -> {
            SlashCommandInfo slashCommand = this.context.getApplicationCommandsContext().findLiveSlashCommand(event.getGuild(), CommandPath.of(event.getFullCommandName()));
            if (slashCommand == null) {
                throwableConsumer.accept(new IllegalArgumentException("A slash command could not be found: '" + event.getFullCommandName() + "'"));
                this.printAvailableCommands((GenericCommandInteractionEvent)event);
                return;
            }
            if (!this.canRun((GenericCommandInteractionEvent)event, slashCommand)) {
                return;
            }
            slashCommand.execute(this.context, event, throwableConsumer);
        }, throwableConsumer);
    }

    private void printAvailableCommands(@NotNull GenericCommandInteractionEvent event) {
        Guild guild = event.getGuild();
        if (LOGGER.isTraceEnabled()) {
            ApplicationCommandInfoMapView commandsMap = this.context.getApplicationCommandsContext().getLiveApplicationCommandsMap(guild);
            String scopeName = guild != null ? "'" + guild.getName() + "'" : "Global scope";
            LOGGER.trace("Commands available in {}: {}", (Object)scopeName, (Object)commandsMap.getAllApplicationCommandsStream().map(commandInfo -> "/" + commandInfo.getPath().getFullPath()).sorted().collect(Collectors.joining("\n")));
        }
        if (this.context.isOnlineAppCommandCheckEnabled()) {
            LOGGER.warn("An application command could not be recognized even though online command check was performed. An update will be forced.\nPlease check if you have another bot instance running as it could have replaced the current command set.\nDo not share your tokens with anyone else (even your friend), and use a separate token when testing.");
            if (guild != null) {
                this.context.scheduleApplicationCommandsUpdate(guild, true, true).whenComplete((wasUpdated, e) -> {
                    if (e != null) {
                        LOGGER.error("An exception occurred while trying to update commands of guild '{}' ({}) after a command was missing", new Object[]{guild.getName(), guild.getId(), e});
                    }
                });
            } else {
                this.context.scheduleGlobalApplicationCommandsUpdate(true, true).whenComplete((wasUpdated, e) -> {
                    if (e != null) {
                        LOGGER.error("An exception occurred while trying to update global commands after a command was missing", e);
                    }
                });
            }
        }
    }

    @NotNull
    public static String reconstructCommand(GenericCommandInteractionEvent event) {
        if (event instanceof SlashCommandInteractionEvent) {
            SlashCommandInteractionEvent slashEvent = (SlashCommandInteractionEvent)event;
            return slashEvent.getCommandString();
        }
        return event.getName();
    }

    private boolean canRun(@NotNull GenericCommandInteractionEvent event, ApplicationCommandInfo applicationCommand) {
        for (ApplicationCommandFilter applicationFilter : this.context.getApplicationFilters()) {
            if (applicationFilter.isAccepted(new ApplicationFilteringData(this.context, event, applicationCommand))) continue;
            LOGGER.trace("Cancelled application commands due to filter");
            return false;
        }
        boolean isNotOwner = !this.context.isOwner(event.getUser().getIdLong());
        Usability usability = Usability.of((Interaction)event, applicationCommand, isNotOwner);
        if (usability.isUnusable()) {
            EnumSet<Usability.UnusableReason> unusableReasons = usability.getUnusableReasons();
            if (unusableReasons.contains((Object)Usability.UnusableReason.OWNER_ONLY)) {
                this.reply((CommandInteraction)event, this.context.getDefaultMessages((Interaction)event).getOwnerOnlyErrorMsg());
                return false;
            }
            if (unusableReasons.contains((Object)Usability.UnusableReason.NSFW_DISABLED)) {
                this.reply((CommandInteraction)event, this.context.getDefaultMessages((Interaction)event).getNsfwDisabledErrorMsg());
                return false;
            }
            if (unusableReasons.contains((Object)Usability.UnusableReason.NSFW_ONLY)) {
                this.reply((CommandInteraction)event, this.context.getDefaultMessages((Interaction)event).getNSFWOnlyErrorMsg());
                return false;
            }
            if (unusableReasons.contains((Object)Usability.UnusableReason.NSFW_DM_DENIED)) {
                this.reply((CommandInteraction)event, this.context.getDefaultMessages((Interaction)event).getNSFWDMDeniedErrorMsg());
                return false;
            }
            if (unusableReasons.contains((Object)Usability.UnusableReason.USER_PERMISSIONS)) {
                this.reply((CommandInteraction)event, this.context.getDefaultMessages((Interaction)event).getUserPermErrorMsg());
                return false;
            }
            if (unusableReasons.contains((Object)Usability.UnusableReason.BOT_PERMISSIONS)) {
                if (event.getGuild() == null) {
                    throw new IllegalStateException("BOT_PERMISSIONS got checked even if guild is null");
                }
                StringJoiner missingBuilder = new StringJoiner(", ");
                EnumSet<Permission> missingPerms = applicationCommand.getBotPermissions();
                missingPerms.removeAll(event.getGuild().getSelfMember().getPermissions(event.getGuildChannel()));
                for (Permission botPermission : missingPerms) {
                    missingBuilder.add(botPermission.getName());
                }
                this.reply((CommandInteraction)event, this.context.getDefaultMessages((Interaction)event).getBotPermErrorMsg(missingBuilder.toString()));
                return false;
            }
        }
        if (isNotOwner) {
            long cooldown = applicationCommand.getCooldown((Interaction)event, () -> ((GenericCommandInteractionEvent)event).getName());
            if (cooldown > 0L) {
                DefaultMessages messages = this.context.getDefaultMessages((Interaction)event);
                if (applicationCommand.getCooldownScope() == CooldownScope.USER) {
                    this.reply((CommandInteraction)event, messages.getUserCooldownMsg((double)cooldown / 1000.0));
                } else if (applicationCommand.getCooldownScope() == CooldownScope.GUILD) {
                    this.reply((CommandInteraction)event, messages.getGuildCooldownMsg((double)cooldown / 1000.0));
                } else {
                    this.reply((CommandInteraction)event, messages.getChannelCooldownMsg((double)cooldown / 1000.0));
                }
                return false;
            }
        }
        return true;
    }

    private void runCommand(RunnableEx code, Consumer<Throwable> throwableConsumer) {
        this.commandService.execute(() -> {
            try {
                code.run();
            }
            catch (Throwable e) {
                throwableConsumer.accept(e);
            }
        });
    }

    private Consumer<Throwable> getThrowableConsumer(GenericCommandInteractionEvent event) {
        return e -> {
            ExceptionHandler handler = this.context.getUncaughtExceptionHandler();
            if (handler != null) {
                handler.onException(this.context, (Event)event, (Throwable)e);
                return;
            }
            Throwable baseEx = Utils.getException(e);
            Utils.printExceptionString("Unhandled exception in thread '" + Thread.currentThread().getName() + "' while executing an application command '" + ApplicationCommandListener.reconstructCommand(event) + "'", baseEx);
            if (event.isAcknowledged()) {
                event.getHook().sendMessage(this.context.getDefaultMessages((Interaction)event).getGeneralErrorMsg()).setEphemeral(true).queue();
            } else {
                event.reply(this.context.getDefaultMessages((Interaction)event).getGeneralErrorMsg()).setEphemeral(true).queue();
            }
            this.context.dispatchException("Exception in application command '" + ApplicationCommandListener.reconstructCommand(event) + "'", baseEx);
        };
    }

    private void reply(CommandInteraction event, String msg) {
        event.reply(msg).setEphemeral(true).queue(null, e -> {
            Utils.printExceptionString("Could not send reply message from application command listener", e);
            this.context.dispatchException("Could not send reply message from application command listener", (Throwable)e);
        });
    }
}

