/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application;

import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.application.diff.DiffLogger;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.utils.data.DataArray;

public class ApplicationCommandsCache {
    private final Path cachePath;

    ApplicationCommandsCache(BContextImpl context) throws IOException {
        this.cachePath = Path.of(System.getProperty("java.io.tmpdir"), context.getJDA().getSelfUser().getId() + "slashcommands");
        Files.createDirectories(this.cachePath, new FileAttribute[0]);
    }

    static byte[] getCommandsBytes(Collection<CommandData> commandData) {
        DataArray json = DataArray.empty();
        json.addAll(commandData);
        return json.toJson();
    }

    public static boolean isJsonContentSame(byte[] oldContentBytes, byte[] newContentBytes) {
        String oldContent = new String(oldContentBytes);
        String newContent = new String(newContentBytes);
        Object oldMap = new Gson().fromJson(oldContent, Object.class);
        Object newMap = new Gson().fromJson(newContent, Object.class);
        DiffLogger diffLogger = DiffLogger.getLogger();
        boolean isSame = ApplicationCommandsCache.checkDiff(oldMap, newMap, diffLogger, 0);
        diffLogger.printLogs();
        return isSame;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean checkDiff(Object oldObj, Object newObj, DiffLogger logger, int indent) {
        block15: {
            block14: {
                if (oldObj == null && newObj == null) {
                    return true;
                }
                if (oldObj == null) {
                    logger.trace(indent, "oldObj is null", new Object[0]);
                    return false;
                }
                if (newObj == null) {
                    logger.trace(indent, "newObj is null", new Object[0]);
                    return false;
                }
                if (oldObj.getClass() != newObj.getClass()) {
                    logger.trace(indent, "Class type not equal: %s to %s", new Object[]{oldObj.getClass().getSimpleName(), newObj.getClass().getSimpleName()});
                    return false;
                }
                if (!(oldObj instanceof Map)) break block14;
                oldMap = (Map)oldObj;
                if (!(newObj instanceof Map)) break block14;
                newMap = (Map)newObj;
                if (!oldMap.keySet().containsAll(newMap.keySet())) {
                    return false;
                }
                for (K key : oldMap.keySet()) {
                    if (ApplicationCommandsCache.checkDiff(oldMap.get(key), newMap.get(key), logger, indent + 1)) continue;
                    logger.trace(indent, "Map value not equal for key '%s': %s to %s", new Object[]{key, oldMap.get(key), newMap.get(key)});
                    return false;
                }
                break block15;
            }
            if (!(oldObj instanceof List)) ** GOTO lbl-1000
            oldList = (List)oldObj;
            if (newObj instanceof List) {
                newList = (List)newObj;
                if (oldList.size() != newList.size()) {
                    return false;
                }
                for (i = 0; i < oldList.size(); ++i) {
                    found = false;
                    index = -1;
                    for (E o : newList) {
                        ++index;
                        if (!ApplicationCommandsCache.checkDiff(oldList.get(i), o, logger, indent + 1)) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        if (i != index && (var12_15 = oldList.get(index)) instanceof Map && (map = (Map)var12_15).get("autocomplete") != null) {
                            logger.trace(indent, "Final command option has changed place from index %s to %s : %s", new Object[]{i, index, oldList.get(i)});
                            return false;
                        }
                        logger.trace(indent, "Found exact object at index %s (original object at %s) : %s", new Object[]{index, i, oldList.get(i)});
                        continue;
                    }
                    if (ApplicationCommandsCache.checkDiff(oldList.get(i), newList.get(i), logger, indent + 1)) continue;
                    logger.trace(indent, "List item not equal: %s to %s", new Object[]{oldList.get(i), newList.get(i)});
                    return false;
                }
            } else lbl-1000:
            // 2 sources

            {
                if (!(equals = oldObj.equals(newObj))) {
                    logger.trace(indent, "Not same object: %s to %s", new Object[]{oldObj, newObj});
                }
                return equals;
            }
        }
        return true;
    }

    Path getGlobalCommandsPath() {
        return this.cachePath.resolve("globalCommands.json");
    }

    Path getGuildCommandsPath(Guild guild) {
        return this.cachePath.resolve(guild.getId()).resolve("commands.json");
    }
}

