/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application;

import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.internal.BContextImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.events.guild.GuildAvailableEvent;
import net.dv8tion.jda.api.events.guild.GuildJoinEvent;
import net.dv8tion.jda.api.events.guild.member.GuildMemberUpdateEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.hooks.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ApplicationUpdaterListener
extends ListenerAdapter {
    private static final Logger LOGGER = Logging.getLogger();
    private final BContextImpl context;
    private final Set<Long> failedGuilds = Collections.synchronizedSet(new HashSet());

    public ApplicationUpdaterListener(BContextImpl context) {
        this.context = context;
    }

    @SubscribeEvent
    public void onGuildAvailable(@NotNull GuildAvailableEvent event) {
        LOGGER.trace("Trying to force update commands due to an unavailable guild becoming available");
        this.tryUpdate(event.getGuild(), true, true);
    }

    @SubscribeEvent
    public void onGuildJoin(@NotNull GuildJoinEvent event) {
        LOGGER.trace("Trying to force update commands due to a joined guild");
        this.tryUpdate(event.getGuild(), true, true);
    }

    @SubscribeEvent
    public void onGuildMemberUpdate(@NotNull GuildMemberUpdateEvent event) {
        if (event.getMember().getIdLong() == event.getJDA().getSelfUser().getIdLong()) {
            LOGGER.trace("Trying to update commands due to a self member update");
            this.tryUpdate(event.getGuild(), false, true);
        }
    }

    private void tryUpdate(Guild guild, boolean force, boolean onlineCheck) {
        boolean hadFailed = this.failedGuilds.remove(guild.getIdLong());
        this.context.getSlashCommandsBuilder().scheduleApplicationCommandsUpdate(guild, force || hadFailed, onlineCheck).whenComplete((commandUpdateResult, e) -> {
            if (e != null) {
                this.failedGuilds.add(guild.getIdLong());
                this.context.getSlashCommandsBuilder().handleApplicationUpdateException(guild, (Throwable)e);
            }
        });
    }
}

