/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.CommandStatus;
import com.freya02.botcommands.api.SettingsProvider;
import com.freya02.botcommands.api.application.ApplicationCommand;
import com.freya02.botcommands.api.application.CommandPath;
import com.freya02.botcommands.internal.application.ApplicationCommandInfo;
import com.freya02.botcommands.internal.utils.Utils;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CommandIdProcessor {
    private static final TLongSet EMPTY_LIST = new TLongHashSet();
    private final Map<String, TLongSet> commandIdToGuildsMap = new HashMap<String, TLongSet>();
    private final Map<CommandPath, Set<String>> commandPathToCommandIdsMap = new HashMap<CommandPath, Set<String>>();
    private final BContext context;

    public CommandIdProcessor(BContext context) {
        this.context = context;
        this.processCommandIds();
    }

    private void processCommandIds() {
        for (ApplicationCommandInfo applicationCommandInfo : this.context.getApplicationCommandsContext().getApplicationCommandInfoMapView().getAllApplicationCommandsView()) {
            Collection<Long> allowedGuilds;
            SettingsProvider settingsProvider;
            String commandId = applicationCommandInfo.getCommandId();
            if (commandId == null) continue;
            CommandPath path = applicationCommandInfo.getPath();
            if (!this.commandPathToCommandIdsMap.computeIfAbsent(path, x -> new HashSet()).add(commandId)) {
                throw new IllegalArgumentException("Tried to insert a duplicated command ID '%s' to path '%s' (in %s)".formatted(commandId, path, Utils.formatMethodShort(applicationCommandInfo.getMethod())));
            }
            Collection<Long> instanceAllowedGuilds = ((ApplicationCommand)applicationCommandInfo.getInstance()).getGuildsForCommandId(this.context, commandId, path);
            if (instanceAllowedGuilds != null) {
                this.commandIdToGuildsMap.computeIfAbsent(commandId, x -> new TLongHashSet()).addAll(instanceAllowedGuilds);
            }
            if ((settingsProvider = this.context.getSettingsProvider()) == null || (allowedGuilds = settingsProvider.getGuildsForCommandId(this.context, commandId, path)) == null) continue;
            this.commandIdToGuildsMap.computeIfAbsent(commandId, x -> new TLongHashSet()).addAll(allowedGuilds);
        }
        for (Map.Entry entry : this.commandPathToCommandIdsMap.entrySet()) {
            TLongObjectHashMap usedGuildIdToCommandIdMap = new TLongObjectHashMap();
            for (String commandId : (Set)entry.getValue()) {
                TLongSet set = this.commandIdToGuildsMap.get(commandId);
                if (set == null) continue;
                set.forEach(arg_0 -> CommandIdProcessor.lambda$processCommandIds$3((TLongObjectMap)usedGuildIdToCommandIdMap, commandId, entry, arg_0));
            }
        }
    }

    public CommandStatus getStatus(@NotNull CommandPath commandPath, @NotNull String commandId, long guildId) {
        TLongSet allowedGuilds = this.commandIdToGuildsMap.getOrDefault(commandId, EMPTY_LIST);
        if (allowedGuilds.contains(guildId)) {
            return CommandStatus.UNSURE;
        }
        if (allowedGuilds != EMPTY_LIST) {
            return CommandStatus.DISABLED;
        }
        Set<String> relatedCommandIds = this.commandPathToCommandIdsMap.get(commandPath);
        if (relatedCommandIds != null) {
            for (String id : relatedCommandIds) {
                TLongSet allowedGuildsOfRelated = this.commandIdToGuildsMap.getOrDefault(id, EMPTY_LIST);
                if (!allowedGuildsOfRelated.contains(guildId)) continue;
                return CommandStatus.DISABLED;
            }
        }
        return CommandStatus.UNSURE;
    }

    private static /* synthetic */ boolean lambda$processCommandIds$3(TLongObjectMap usedGuildIdToCommandIdMap, String commandId, Map.Entry entry, long guildId) {
        String oldId = (String)usedGuildIdToCommandIdMap.put(guildId, (Object)commandId);
        if (oldId != null) {
            throw new IllegalArgumentException("Guild ID %d has two commands IDs ('%s' and '%s') that share the same path '%s'".formatted(guildId, oldId, commandId, entry.getKey()));
        }
        return true;
    }
}

