/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application;

import com.freya02.botcommands.api.application.CommandPath;
import com.freya02.botcommands.internal.AbstractCommandInfo;
import com.freya02.botcommands.internal.application.ApplicationCommandInfo;
import com.freya02.botcommands.internal.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class CommandInfoMap<T extends ApplicationCommandInfo>
implements Map<CommandPath, T> {
    private final Map<CommandPath, T> map;

    public CommandInfoMap() {
        this.map = Collections.synchronizedMap(new HashMap());
    }

    public CommandInfoMap(Map<CommandPath, T> map) {
        this.map = map;
    }

    public @UnmodifiableView CommandInfoMap<T> unmodifiable() {
        return new CommandInfoMap<T>(Collections.unmodifiableMap(this.map));
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public T get(Object key) {
        return (T)((ApplicationCommandInfo)this.map.get(key));
    }

    @Override
    @Nullable
    public T put(CommandPath key, T value) {
        for (Map.Entry<CommandPath, T> entry : this.entrySet()) {
            CommandPath commandPath = entry.getKey();
            ApplicationCommandInfo mapInfo = (ApplicationCommandInfo)entry.getValue();
            if (key.getFullPath().equals(commandPath.getName())) {
                throw new IllegalStateException(String.format("Tried to add a command with path '%s' (at %s) but a equal/longer path already exists: '%s' (at %s)", key, Utils.formatMethodShort(((AbstractCommandInfo)value).getMethod()), commandPath, Utils.formatMethodShort(mapInfo.getMethod())));
            }
            if (!commandPath.getFullPath().equals(key.getName())) continue;
            throw new IllegalStateException(String.format("Tried to add a command with path '%s' (at %s) but a top level command already exists: '%s' (at %s)", key, Utils.formatMethodShort(((AbstractCommandInfo)value).getMethod()), commandPath, Utils.formatMethodShort(mapInfo.getMethod())));
        }
        ApplicationCommandInfo oldInfo = (ApplicationCommandInfo)this.map.put(key, value);
        if (oldInfo != null) {
            throw new IllegalStateException(String.format("Tried to add a command with path '%s' (at %s) but an equal path already exists: '%s' (at %s)", key, Utils.formatMethodShort(((AbstractCommandInfo)value).getMethod()), oldInfo.getPath(), Utils.formatMethodShort(oldInfo.getMethod())));
        }
        return null;
    }

    @Override
    public T remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@NotNull Map<? extends CommandPath, ? extends T> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<CommandPath> keySet() {
        return new HashSet<CommandPath>(this.map.keySet());
    }

    @Override
    @NotNull
    public Collection<T> values() {
        return new ArrayList<T>(this.map.values());
    }

    @Override
    @NotNull
    public Set<Map.Entry<CommandPath, T>> entrySet() {
        return new HashSet<Map.Entry<CommandPath, T>>(this.map.entrySet());
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public T getOrDefault(Object key, T defaultValue) {
        return (T)((ApplicationCommandInfo)this.map.getOrDefault(key, defaultValue));
    }

    @Override
    public void forEach(BiConsumer<? super CommandPath, ? super T> action) {
        this.map.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super CommandPath, ? super T, ? extends T> function) {
        this.map.replaceAll(function);
    }

    @Override
    @Nullable
    public T putIfAbsent(CommandPath key, T value) {
        return (T)((ApplicationCommandInfo)this.map.putIfAbsent(key, value));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    @Override
    public boolean replace(CommandPath key, T oldValue, T newValue) {
        return this.map.replace(key, oldValue, newValue);
    }

    @Override
    @Nullable
    public T replace(CommandPath key, T value) {
        return (T)((ApplicationCommandInfo)this.map.replace(key, value));
    }

    @Override
    public T computeIfAbsent(CommandPath key, @NotNull Function<? super CommandPath, ? extends T> mappingFunction) {
        return (T)((ApplicationCommandInfo)this.map.computeIfAbsent(key, mappingFunction));
    }

    @Override
    public T computeIfPresent(CommandPath key, @NotNull BiFunction<? super CommandPath, ? super T, ? extends T> remappingFunction) {
        return (T)((ApplicationCommandInfo)this.map.computeIfPresent(key, remappingFunction));
    }

    @Override
    public T compute(CommandPath key, @NotNull BiFunction<? super CommandPath, ? super T, ? extends T> remappingFunction) {
        return (T)((ApplicationCommandInfo)this.map.compute(key, remappingFunction));
    }

    @Override
    public T merge(CommandPath key, @NotNull T value, @NotNull BiFunction<? super T, ? super T, ? extends T> remappingFunction) {
        return (T)((ApplicationCommandInfo)this.map.merge(key, value, remappingFunction));
    }
}

