/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application;

import com.freya02.botcommands.api.parameters.CustomResolver;
import com.freya02.botcommands.api.parameters.ParameterResolver;
import com.freya02.botcommands.api.parameters.ParameterResolvers;
import com.freya02.botcommands.internal.utils.ReflectionUtils;
import com.freya02.botcommands.internal.utils.StringUtils;
import com.freya02.botcommands.internal.utils.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommandParameter<RESOLVER> {
    private final RESOLVER resolver;
    private final Class<?> boxedType;
    private final CustomResolver customResolver;
    private final Parameter parameter;
    private final int index;
    private final boolean optional;
    private final boolean isPrimitive;

    protected abstract List<Class<? extends Annotation>> getOptionAnnotations();

    protected List<Class<? extends Annotation>> getResolvableAnnotations() {
        return this.getOptionAnnotations();
    }

    public CommandParameter(@Nullable Class<RESOLVER> resolverType, Parameter parameter, int index) {
        this(resolverType, parameter, Utils.getBoxedType(parameter.getType()), index);
    }

    public CommandParameter(@Nullable Class<RESOLVER> resolverType, Parameter parameter, Class<?> boxedType, int index) {
        this.parameter = parameter;
        this.boxedType = boxedType;
        this.index = index;
        this.optional = ReflectionUtils.isOptional(parameter);
        this.isPrimitive = parameter.getType().isPrimitive();
        ParameterResolver resolver = ParameterResolvers.of(this.boxedType);
        List<Class<Annotation>> allowedAnnotation = this.getOptionAnnotations();
        List<Class<Annotation>> resolvableAnnotation = this.getResolvableAnnotations();
        if (allowedAnnotation.stream().anyMatch(parameter::isAnnotationPresent)) {
            if (resolvableAnnotation.stream().noneMatch(parameter::isAnnotationPresent)) {
                this.resolver = null;
                this.customResolver = null;
                return;
            }
            if (resolverType == null) {
                throw new IllegalArgumentException("Parameter of type " + boxedType.getName() + " is an annotated as an option but doesn't have a resolver type attached, please report to devs");
            }
            if (resolver == null) {
                throw new IllegalArgumentException("Unknown interaction command option type: " + boxedType.getName() + " for target resolver " + resolverType.getName());
            }
            if (!resolverType.isAssignableFrom(resolver.getClass())) {
                throw new IllegalArgumentException("Unsupported interaction command option type: " + boxedType.getName() + " for target resolver " + resolverType.getName());
            }
            this.resolver = resolver;
            this.customResolver = null;
        } else {
            this.resolver = null;
            if (resolver instanceof CustomResolver) {
                this.customResolver = (CustomResolver)resolver;
            } else {
                throw new IllegalArgumentException("Unsupported custom parameter: %s, did you forget to use %s on non-custom options ?".formatted(boxedType.getName(), StringUtils.naturalJoin("or", allowedAnnotation.stream().map(Class::getSimpleName).toList())));
            }
        }
    }

    public CustomResolver getCustomResolver() {
        return this.customResolver;
    }

    public RESOLVER getResolver() {
        return this.resolver;
    }

    @NotNull
    public Class<?> getBoxedType() {
        return this.boxedType;
    }

    @NotNull
    public Parameter getParameter() {
        return this.parameter;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isOption() {
        return this.resolver != null;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isOptional() {
        return this.optional;
    }
}

