/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application;

import com.freya02.botcommands.api.application.CommandPath;
import java.util.Objects;
import java.util.StringJoiner;
import net.dv8tion.jda.internal.utils.Checks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandPathImpl
implements CommandPath {
    private final String name;
    private final String group;
    private final String subname;
    private final String path;
    private final int count;

    public CommandPathImpl(@NotNull String name, @Nullable String group, @Nullable String subname) {
        Checks.notBlank((CharSequence)name, (String)"Command base name");
        if (group != null) {
            Checks.notBlank((CharSequence)group, (String)"Subcommand group name");
        }
        if (subname != null) {
            Checks.notBlank((CharSequence)subname, (String)"Subcommand name");
        }
        this.name = name;
        this.group = group;
        this.subname = subname;
        StringJoiner joiner = new StringJoiner(" ");
        joiner.add(name);
        if (group != null) {
            joiner.add(group);
        }
        if (subname != null) {
            joiner.add(subname);
        }
        this.path = joiner.toString();
        int count = 1;
        if (group != null) {
            ++count;
        }
        if (subname != null) {
            ++count;
        }
        this.count = count;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getGroup() {
        return this.group;
    }

    @Override
    @Nullable
    public String getSubname() {
        return this.subname;
    }

    @Override
    public int getNameCount() {
        return this.count;
    }

    @Override
    @Nullable
    public CommandPath getParent() {
        if (this.group != null && this.subname != null) {
            return CommandPath.of(this.name, this.group);
        }
        if (this.group != null) {
            return CommandPath.ofName(this.name);
        }
        if (this.subname != null) {
            return CommandPath.ofName(this.name);
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandPathImpl that = (CommandPathImpl)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    @NotNull
    public String getFullPath() {
        return this.path;
    }

    @Override
    @NotNull
    public String getFullPath(char separator) {
        return this.path.replace(' ', separator);
    }

    @Override
    @NotNull
    public String getLastName() {
        if (this.group != null) {
            return this.subname;
        }
        if (this.subname != null) {
            return this.subname;
        }
        return this.name;
    }

    @Override
    @Nullable
    public String getNameAt(int i) {
        return switch (i) {
            case 0 -> this.name;
            case 1 -> {
                if (this.group != null) {
                    yield this.group;
                }
                yield this.subname;
            }
            case 2 -> this.subname;
            default -> throw new IllegalArgumentException("Invalid name count: " + i);
        };
    }

    @Override
    @NotNull
    public String toString() {
        return this.path;
    }

    @Override
    public boolean startsWith(CommandPath o) {
        if (o.getNameCount() > this.getNameCount()) {
            return false;
        }
        for (int i = 0; i < Math.min(this.getNameCount(), o.getNameCount()); ++i) {
            if (Objects.equals(o.getNameAt(i), this.getNameAt(i))) continue;
            return false;
        }
        return true;
    }
}

