/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application.context.message;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.application.ApplicationCommand;
import com.freya02.botcommands.api.application.context.annotations.JDAMessageCommand;
import com.freya02.botcommands.api.application.context.message.GlobalMessageEvent;
import com.freya02.botcommands.api.application.context.message.GuildMessageEvent;
import com.freya02.botcommands.api.parameters.MessageContextParameterResolver;
import com.freya02.botcommands.api.prefixed.annotations.TextOption;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.MethodParameters;
import com.freya02.botcommands.internal.application.ApplicationCommandInfo;
import com.freya02.botcommands.internal.application.context.ContextCommandParameter;
import com.freya02.botcommands.internal.utils.Utils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.function.Consumer;
import java.util.function.Function;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.api.events.interaction.command.MessageContextInteractionEvent;
import net.dv8tion.jda.api.interactions.Interaction;
import org.jetbrains.annotations.NotNull;

public class MessageCommandInfo
extends ApplicationCommandInfo {
    private final MethodParameters<ContextCommandParameter<MessageContextParameterResolver>> commandParameters;

    public MessageCommandInfo(BContext context, ApplicationCommand instance, Method method) {
        super(context, instance, method.getAnnotation(JDAMessageCommand.class), method, (Function<A, String>[])new Function[]{JDAMessageCommand::name});
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (!GlobalMessageEvent.class.isAssignableFrom(parameterTypes[0])) {
            throw new IllegalArgumentException("First argument should be a GlobalUserEvent for method " + Utils.formatMethodShort(method));
        }
        this.commandParameters = MethodParameters.of(context, method, (parameter, i) -> {
            if (parameter.isAnnotationPresent(TextOption.class)) {
                throw new IllegalArgumentException(String.format("Message command parameter #%d of %s#%s cannot be annotated with @TextOption", i, this.commandMethod.getDeclaringClass().getName(), this.commandMethod.getName()));
            }
            return new ContextCommandParameter<MessageContextParameterResolver>(context, this.path, MessageContextParameterResolver.class, (Parameter)parameter, (int)i);
        });
    }

    public boolean execute(BContextImpl context, MessageContextInteractionEvent event, Consumer<Throwable> throwableConsumer) throws Exception {
        Object[] objects = new Object[this.commandParameters.size() + 1];
        objects[0] = this.guildOnly ? new GuildMessageEvent(this.getMethod(), context, event) : new GlobalMessageEvent(this.getMethod(), context, event);
        int commandParametersLength = this.commandParameters.size();
        for (int i = 0; i < commandParametersLength; ++i) {
            ContextCommandParameter parameter = (ContextCommandParameter)this.commandParameters.get(i);
            objects[i + 1] = parameter.isOption() ? ((MessageContextParameterResolver)parameter.getResolver()).resolve(context, this, event) : parameter.getCustomResolver().resolve(context, this, (Event)event);
        }
        this.applyCooldown((Interaction)event);
        this.getMethodRunner().invoke(objects, throwableConsumer);
        return true;
    }

    @NotNull
    public MethodParameters<ContextCommandParameter<MessageContextParameterResolver>> getParameters() {
        return this.commandParameters;
    }
}

