/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application.context.user;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.application.ApplicationCommand;
import com.freya02.botcommands.api.application.context.annotations.JDAUserCommand;
import com.freya02.botcommands.api.application.context.user.GlobalUserEvent;
import com.freya02.botcommands.api.application.context.user.GuildUserEvent;
import com.freya02.botcommands.api.parameters.UserContextParameterResolver;
import com.freya02.botcommands.api.prefixed.annotations.TextOption;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.MethodParameters;
import com.freya02.botcommands.internal.application.ApplicationCommandInfo;
import com.freya02.botcommands.internal.application.context.ContextCommandParameter;
import com.freya02.botcommands.internal.utils.Utils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.function.Consumer;
import java.util.function.Function;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.api.events.interaction.command.UserContextInteractionEvent;
import net.dv8tion.jda.api.interactions.Interaction;
import org.jetbrains.annotations.NotNull;

public class UserCommandInfo
extends ApplicationCommandInfo {
    private final MethodParameters<ContextCommandParameter<UserContextParameterResolver>> commandParameters;

    public UserCommandInfo(BContext context, ApplicationCommand instance, Method method) {
        super(context, instance, method.getAnnotation(JDAUserCommand.class), method, (Function<A, String>[])new Function[]{JDAUserCommand::name});
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (!GlobalUserEvent.class.isAssignableFrom(parameterTypes[0])) {
            throw new IllegalArgumentException("First argument should be a GlobalUserEvent for method " + Utils.formatMethodShort(method));
        }
        this.commandParameters = MethodParameters.of(context, method, (parameter, i) -> {
            if (parameter.isAnnotationPresent(TextOption.class)) {
                throw new IllegalArgumentException(String.format("User command parameter #%d of %s#%s cannot be annotated with @TextOption", i, this.commandMethod.getDeclaringClass().getName(), this.commandMethod.getName()));
            }
            Class<?> type = parameter.getType();
            if (Member.class.isAssignableFrom(type) && !this.isGuildOnly()) {
                throw new IllegalArgumentException("The user command " + Utils.formatMethodShort(this.commandMethod) + " cannot have a " + type.getSimpleName() + " parameter as it is not guild-only");
            }
            return new ContextCommandParameter<UserContextParameterResolver>(context, this.path, UserContextParameterResolver.class, (Parameter)parameter, (int)i);
        });
    }

    public boolean execute(BContextImpl context, UserContextInteractionEvent event, Consumer<Throwable> throwableConsumer) throws Exception {
        Object[] objects = new Object[this.commandParameters.size() + 1];
        objects[0] = this.guildOnly ? new GuildUserEvent(this.getMethod(), context, event) : new GlobalUserEvent(this.getMethod(), context, event);
        int commandParametersLength = this.commandParameters.size();
        for (int i = 0; i < commandParametersLength; ++i) {
            ContextCommandParameter parameter = (ContextCommandParameter)this.commandParameters.get(i);
            objects[i + 1] = parameter.isOption() ? ((UserContextParameterResolver)parameter.getResolver()).resolve(context, this, event) : parameter.getCustomResolver().resolve(context, this, (Event)event);
        }
        this.applyCooldown((Interaction)event);
        this.getMethodRunner().invoke(objects, throwableConsumer);
        return true;
    }

    @NotNull
    public MethodParameters<ContextCommandParameter<UserContextParameterResolver>> getParameters() {
        return this.commandParameters;
    }
}

