/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application.localization;

import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.builder.DebugBuilder;
import com.freya02.botcommands.api.localization.Localization;
import com.freya02.botcommands.api.localization.LocalizationTemplate;
import com.freya02.botcommands.internal.BContextImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.dv8tion.jda.api.interactions.DiscordLocale;
import net.dv8tion.jda.api.interactions.commands.localization.LocalizationFunction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class BCLocalizationFunction
implements LocalizationFunction {
    private static final Logger LOGGER = Logging.getLogger();
    private final Map<String, List<Locale>> baseNameToLocalesMap;

    public BCLocalizationFunction(BContextImpl context) {
        this.baseNameToLocalesMap = context.getApplicationCommandsContext().getBaseNameToLocalesMap();
    }

    @NotNull
    public Map<DiscordLocale, String> apply(@NotNull String localizationKey) {
        HashMap<DiscordLocale, String> map = new HashMap<DiscordLocale, String>();
        this.baseNameToLocalesMap.forEach((baseName, locales) -> {
            for (Locale locale : locales) {
                Localization instance = Localization.getInstance(baseName, locale);
                if (instance != null) {
                    LocalizationTemplate template;
                    if (instance.getEffectiveLocale() != locale && Logging.tryLog(baseName, locale.toLanguageTag(), instance.getEffectiveLocale().toLanguageTag())) {
                        LOGGER.warn("Localization bundle '{}' with locale '{}' was specified to be valid but was not found, falling back to '{}'", new Object[]{baseName, locale, instance.getEffectiveLocale()});
                    }
                    if ((template = instance.get(localizationKey)) != null) {
                        map.put(DiscordLocale.from((Locale)locale), template.localize(new Localization.Entry[0]));
                        continue;
                    }
                    if (!DebugBuilder.isLogMissingLocalizationEnabled() || !Logging.tryLog(baseName, locale.toLanguageTag(), localizationKey)) continue;
                    LOGGER.warn("Localization template '{}' could not be found in bundle '{}' with locale '{}' or below", new Object[]{localizationKey, baseName, locale});
                    continue;
                }
                if (!Logging.tryLog(baseName, locale.toLanguageTag())) continue;
                LOGGER.warn("Localization bundle '{}' with locale '{}' was specified to be valid but was not found.", baseName, (Object)locale);
            }
        });
        return map;
    }
}

