/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application.slash;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.application.ApplicationCommand;
import com.freya02.botcommands.api.application.slash.DefaultValueSupplier;
import com.freya02.botcommands.api.application.slash.GuildSlashEvent;
import com.freya02.botcommands.api.application.slash.annotations.JDASlashCommand;
import com.freya02.botcommands.api.parameters.SlashParameterResolver;
import com.freya02.botcommands.internal.ApplicationOptionData;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.MethodParameters;
import com.freya02.botcommands.internal.application.ApplicationCommandInfo;
import com.freya02.botcommands.internal.application.slash.GlobalSlashEventImpl;
import com.freya02.botcommands.internal.application.slash.SlashCommandParameter;
import com.freya02.botcommands.internal.application.slash.SlashUtils;
import com.freya02.botcommands.internal.utils.LocalizationUtils;
import com.freya02.botcommands.internal.utils.Utils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.AutoCompleteQuery;
import net.dv8tion.jda.api.interactions.Interaction;
import net.dv8tion.jda.api.interactions.commands.CommandInteractionPayload;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SlashCommandInfo
extends ApplicationCommandInfo {
    private static final Logger LOGGER = Logging.getLogger();
    private final String description;
    private final MethodParameters<SlashCommandParameter> commandParameters;

    public SlashCommandInfo(BContext context, ApplicationCommand instance, Method commandMethod) {
        super(context, instance, commandMethod.getAnnotation(JDASlashCommand.class), commandMethod, (Function<A, String>[])new Function[]{JDASlashCommand::name, JDASlashCommand::group, JDASlashCommand::subcommand});
        JDASlashCommand annotation = commandMethod.getAnnotation(JDASlashCommand.class);
        this.commandParameters = MethodParameters.of(context, commandMethod, (parameter, index) -> new SlashCommandParameter(context, this.path, (Parameter)parameter, (int)index));
        if (!annotation.group().isBlank() && annotation.subcommand().isBlank()) {
            throw new IllegalArgumentException("Command group for " + Utils.formatMethodShort(commandMethod) + " is present but has no subcommand");
        }
        this.description = this.getDescription((BContextImpl)context, annotation);
    }

    private String getDescription(BContextImpl context, JDASlashCommand annotation) {
        String joinedPath = this.path.getFullPath('.');
        String rootLocalization = LocalizationUtils.getCommandRootLocalization(context, joinedPath + ".description");
        if (rootLocalization != null) {
            return rootLocalization;
        }
        return annotation.description();
    }

    public String getDescription() {
        return this.description;
    }

    public boolean execute(final BContextImpl context, final SlashCommandInteractionEvent event, Consumer<Throwable> throwableConsumer) throws Exception {
        ArrayList<Object> objects = new ArrayList<Object>(this.commandParameters.size() + 1){
            {
                super(initialCapacity);
                if (SlashCommandInfo.this.guildOnly) {
                    this.add(new GuildSlashEvent(context, SlashCommandInfo.this.getMethod(), event));
                } else {
                    this.add(new GlobalSlashEventImpl(context, SlashCommandInfo.this.getMethod(), event));
                }
            }
        };
        for (SlashCommandParameter parameter : this.commandParameters) {
            DefaultValueSupplier supplier;
            Guild guild = event.getGuild();
            if (guild != null && (supplier = (DefaultValueSupplier)parameter.getDefaultOptionSupplierMap().get(guild.getIdLong())) != null) {
                Object defaultVal = supplier.getDefaultValue((CommandInteractionPayload)event);
                SlashUtils.checkDefaultValue(this, parameter, defaultVal);
                objects.add(defaultVal);
                continue;
            }
            int arguments = Math.max(1, parameter.getVarArgs());
            ArrayList<Object> objectList = new ArrayList<Object>(arguments);
            ApplicationOptionData applicationOptionData = parameter.getApplicationOptionData();
            if (parameter.isOption()) {
                String optionName = applicationOptionData.getEffectiveName();
                for (int varArgNum = 0; varArgNum < arguments; ++varArgNum) {
                    String varArgName = SlashUtils.getVarArgName(optionName, varArgNum);
                    OptionMapping optionMapping = event.getOption(varArgName);
                    if (optionMapping == null) {
                        if (parameter.isOptional() || parameter.isVarArg() && !parameter.isRequiredVararg(varArgNum)) {
                            if (parameter.isPrimitive()) {
                                objectList.add(0);
                                continue;
                            }
                            objectList.add(null);
                            continue;
                        }
                        throw new RuntimeException("Slash parameter couldn't be resolved for method " + Utils.formatMethodShort(this.commandMethod) + " at parameter " + applicationOptionData.getEffectiveName() + " (" + varArgName + ")");
                    }
                    Object resolved = ((SlashParameterResolver)parameter.getResolver()).resolve(context, this, (CommandInteractionPayload)event, optionMapping);
                    if (resolved == null) {
                        event.reply(context.getDefaultMessages((Interaction)event).getSlashCommandUnresolvableParameterMsg(applicationOptionData.getEffectiveName(), parameter.getBoxedType().getSimpleName())).setEphemeral(true).queue();
                        LOGGER.trace("The parameter '{}' of value '{}' could not be resolved into a {}", new Object[]{applicationOptionData.getEffectiveName(), optionMapping.getAsString(), parameter.getBoxedType().getSimpleName()});
                        return false;
                    }
                    if (!parameter.getBoxedType().isAssignableFrom(resolved.getClass())) {
                        throw new IllegalArgumentException("The parameter '%s' of value '%s' is not a valid type (expected a %s)".formatted(applicationOptionData.getEffectiveName(), optionMapping.getAsString(), parameter.getBoxedType().getSimpleName()));
                    }
                    objectList.add(resolved);
                }
            } else {
                objectList.add(parameter.getCustomResolver().resolve(context, this, (Event)event));
            }
            objects.add(parameter.isVarArg() ? objectList : objectList.get(0));
        }
        this.applyCooldown((Interaction)event);
        this.getMethodRunner().invoke(objects.toArray(), throwableConsumer);
        return true;
    }

    @Nullable
    public String getAutocompletionHandlerName(CommandAutoCompleteInteractionEvent event) {
        AutoCompleteQuery autoCompleteQuery = event.getFocusedOption();
        for (SlashCommandParameter parameter : this.commandParameters) {
            String optionName;
            ApplicationOptionData applicationOptionData = parameter.getApplicationOptionData();
            if (!parameter.isOption() || !(optionName = applicationOptionData.getEffectiveName()).equals(autoCompleteQuery.getName())) continue;
            return applicationOptionData.getAutocompletionHandlerName();
        }
        return null;
    }

    @NotNull
    public MethodParameters<SlashCommandParameter> getParameters() {
        return this.commandParameters;
    }

    @NotNull
    public List<? extends SlashCommandParameter> getOptionParameters() {
        return super.getOptionParameters();
    }
}

