/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application.slash.autocomplete;

import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.application.slash.DefaultValueSupplier;
import com.freya02.botcommands.api.application.slash.annotations.VarArgs;
import com.freya02.botcommands.api.application.slash.autocomplete.AutocompletionMode;
import com.freya02.botcommands.api.application.slash.autocomplete.AutocompletionTransformer;
import com.freya02.botcommands.api.application.slash.autocomplete.annotations.AutocompletionHandler;
import com.freya02.botcommands.api.application.slash.autocomplete.annotations.CacheAutocompletion;
import com.freya02.botcommands.api.parameters.SlashParameterResolver;
import com.freya02.botcommands.internal.ApplicationOptionData;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.ConsumerEx;
import com.freya02.botcommands.internal.ExecutableInteractionInfo;
import com.freya02.botcommands.internal.MethodParameters;
import com.freya02.botcommands.internal.application.slash.SlashCommandInfo;
import com.freya02.botcommands.internal.application.slash.SlashCommandParameter;
import com.freya02.botcommands.internal.application.slash.SlashUtils;
import com.freya02.botcommands.internal.application.slash.autocomplete.AutocompleteCommandParameter;
import com.freya02.botcommands.internal.application.slash.autocomplete.ChoiceSupplier;
import com.freya02.botcommands.internal.application.slash.autocomplete.CompositeAutocompletionKey;
import com.freya02.botcommands.internal.application.slash.autocomplete.caches.AbstractAutocompletionCache;
import com.freya02.botcommands.internal.application.slash.autocomplete.suppliers.ChoiceSupplierChoices;
import com.freya02.botcommands.internal.application.slash.autocomplete.suppliers.ChoiceSupplierStringContinuity;
import com.freya02.botcommands.internal.application.slash.autocomplete.suppliers.ChoiceSupplierStringFuzzy;
import com.freya02.botcommands.internal.application.slash.autocomplete.suppliers.ChoiceSupplierTransformer;
import com.freya02.botcommands.internal.runner.MethodRunner;
import com.freya02.botcommands.internal.utils.ReflectionUtils;
import com.freya02.botcommands.internal.utils.Utils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.interactions.AutoCompleteQuery;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.CommandInteractionPayload;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class AutocompletionHandlerInfo
implements ExecutableInteractionInfo {
    private static final Logger LOGGER = Logging.getLogger();
    private final BContextImpl context;
    private final Object autocompletionHandler;
    private final Method method;
    private final MethodRunner methodRunner;
    private final String handlerName;
    private final boolean showUserInput;
    private final int maxChoices;
    private final ChoiceSupplier choiceSupplier;
    private final MethodParameters<AutocompleteCommandParameter> autocompleteParameters;
    private final AbstractAutocompletionCache cache;

    public AutocompletionHandlerInfo(BContextImpl context, Object autocompletionHandler, Method method) {
        this.context = context;
        this.autocompletionHandler = autocompletionHandler;
        this.method = method;
        this.methodRunner = context.getMethodRunnerFactory().make(autocompletionHandler, method);
        AutocompletionHandler annotation = method.getAnnotation(AutocompletionHandler.class);
        AutocompletionMode autocompletionMode = annotation.mode();
        CacheAutocompletion cacheAutocompletion = method.getAnnotation(CacheAutocompletion.class);
        this.cache = AbstractAutocompletionCache.fromMode(this, cacheAutocompletion);
        this.handlerName = annotation.name();
        this.showUserInput = annotation.showUserInput();
        this.maxChoices = 25 - (this.showUserInput ? 1 : 0);
        Class<?> collectionReturnType = ReflectionUtils.getCollectionReturnType(method);
        if (collectionReturnType == null) {
            throw new IllegalArgumentException("Unable to determine return type of " + Utils.formatMethodShort(method) + ", does the collection inherit Collection ?");
        }
        if (String.class.isAssignableFrom(collectionReturnType) || Long.class.isAssignableFrom(collectionReturnType) || Double.class.isAssignableFrom(collectionReturnType)) {
            this.choiceSupplier = this.generateSupplierFromStrings(autocompletionMode);
        } else if (Command.Choice.class.isAssignableFrom(collectionReturnType)) {
            this.choiceSupplier = new ChoiceSupplierChoices(this);
        } else {
            AutocompletionTransformer<Object> transformer = context.getAutocompletionTransformer(collectionReturnType);
            if (transformer == null) {
                throw new IllegalArgumentException("No autocompletion transformer has been register for objects of type '" + collectionReturnType.getSimpleName() + "', for method " + Utils.formatMethodShort(method) + ", you may also check the docs for " + AutocompletionHandler.class.getSimpleName());
            }
            this.choiceSupplier = new ChoiceSupplierTransformer(this, transformer);
        }
        this.autocompleteParameters = MethodParameters.of(context, method, (parameter, index) -> new AutocompleteCommandParameter(context, null, (Parameter)parameter, (int)index));
    }

    public static Command.Choice getChoice(OptionType type, String string) {
        return switch (type) {
            case OptionType.STRING -> {
                Command.Choice var2_2;
                yield var2_2 = new Command.Choice(string, string);
            }
            case OptionType.INTEGER -> {
                try {
                    Command.Choice var2_3;
                    yield var2_3 = new Command.Choice(string, Long.parseLong(string));
                }
                catch (NumberFormatException e) {
                    Command.Choice var2_4;
                    yield var2_4 = null;
                }
            }
            case OptionType.NUMBER -> {
                try {
                    Command.Choice var2_5;
                    yield var2_5 = new Command.Choice(string, Double.parseDouble(string));
                }
                catch (NumberFormatException e) {
                    Command.Choice var2_6;
                    yield var2_6 = null;
                }
            }
            default -> throw new IllegalArgumentException("Invalid autocompletion option type: " + type);
        };
    }

    private void invokeAutocompletionHandler(SlashCommandInfo slashCommand, CommandAutoCompleteInteractionEvent event, Consumer<Throwable> throwableConsumer, ConsumerEx<Collection<?>> collectionCallback) throws Exception {
        ArrayList<Object> objects = new ArrayList<Object>(this.autocompleteParameters.size() + 1);
        objects.add(event);
        for (AutocompleteCommandParameter parameter : this.autocompleteParameters) {
            SlashCommandParameter slashParameter;
            DefaultValueSupplier supplier;
            Guild guild = event.getGuild();
            if (guild != null && parameter.isOption() && (supplier = (DefaultValueSupplier)(slashParameter = slashCommand.getParameters().stream().filter(p -> p.getApplicationOptionData().getEffectiveName().equals(parameter.getApplicationOptionData().getEffectiveName())).findAny().orElseThrow(() -> new IllegalArgumentException("Could not find corresponding slash command parameter '" + parameter.getApplicationOptionData().getEffectiveName() + "' when using autocomplete"))).getDefaultOptionSupplierMap().get(guild.getIdLong())) != null) {
                Object defaultVal = supplier.getDefaultValue((CommandInteractionPayload)event);
                SlashUtils.checkDefaultValue(this, parameter, defaultVal);
                objects.add(defaultVal);
                continue;
            }
            int arguments = Math.max(1, parameter.getVarArgs());
            ArrayList<Object> objectList = new ArrayList<Object>(arguments);
            ApplicationOptionData applicationOptionData = parameter.getApplicationOptionData();
            for (int varArgNum = 0; varArgNum < arguments; ++varArgNum) {
                if (parameter.isOption()) {
                    String optionName = applicationOptionData.getEffectiveName();
                    String varArgName = SlashUtils.getVarArgName(optionName, varArgNum);
                    OptionMapping optionMapping = event.getOption(varArgName);
                    if (optionMapping == null || optionMapping.getAsString().isEmpty() || parameter.isPrimitive() && !optionMapping.getAsString().chars().allMatch(i -> Character.isDigit(i) || i == 46)) {
                        if (parameter.isPrimitive()) {
                            objectList.add(0);
                            continue;
                        }
                        objectList.add(null);
                        continue;
                    }
                    Object resolved = ((SlashParameterResolver)parameter.getResolver()).resolve(this.context, slashCommand, (CommandInteractionPayload)event, optionMapping);
                    if (resolved == null) {
                        LOGGER.trace("The parameter '{}' of value '{}' could not be resolved into a {}", new Object[]{applicationOptionData.getEffectiveName(), optionMapping.getAsString(), parameter.getBoxedType().getSimpleName()});
                        return;
                    }
                    if (!parameter.getBoxedType().isAssignableFrom(resolved.getClass())) {
                        LOGGER.error("The parameter '{}' of value '{}' is not a valid type (expected a {})", new Object[]{applicationOptionData.getEffectiveName(), optionMapping.getAsString(), parameter.getBoxedType().getSimpleName()});
                        return;
                    }
                    objectList.add(resolved);
                    continue;
                }
                objectList.add(parameter.getCustomResolver().resolve(this.context, this, (Event)event));
            }
            objects.add(parameter.isVarArg() ? objectList : objectList.get(0));
        }
        this.methodRunner.invoke(objects.toArray(), throwableConsumer, collectionCallback);
    }

    private ChoiceSupplier generateSupplierFromStrings(AutocompletionMode autocompletionMode) {
        if (autocompletionMode == AutocompletionMode.FUZZY) {
            return new ChoiceSupplierStringFuzzy(this);
        }
        return new ChoiceSupplierStringContinuity(this);
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public void retrieveChoices(SlashCommandInfo slashCommand, CommandAutoCompleteInteractionEvent event, Consumer<Throwable> throwableConsumer, Consumer<List<Command.Choice>> choiceCallback) throws Exception {
        this.cache.retrieveAndCall(event, choiceCallback, key -> this.generateChoices(slashCommand, event, throwableConsumer, choices -> {
            this.cache.put((CompositeAutocompletionKey)key, (List<Command.Choice>)choices);
            choiceCallback.accept((List<Command.Choice>)choices);
        }));
    }

    private void generateChoices(SlashCommandInfo slashCommand, CommandAutoCompleteInteractionEvent event, Consumer<Throwable> throwableConsumer, ConsumerEx<List<Command.Choice>> choiceCallback) throws Exception {
        this.invokeAutocompletionHandler(slashCommand, event, throwableConsumer, collection -> {
            Command.Choice choice;
            ArrayList<Command.Choice> actualChoices = new ArrayList<Command.Choice>(25);
            List<Command.Choice> suppliedChoices = this.choiceSupplier.apply(event, (Collection<?>)collection);
            AutoCompleteQuery autoCompleteQuery = event.getFocusedOption();
            if (this.showUserInput && !autoCompleteQuery.getValue().isBlank() && !suppliedChoices.isEmpty() && (choice = AutocompletionHandlerInfo.getChoice(autoCompleteQuery.getType(), autoCompleteQuery.getValue())) != null) {
                actualChoices.add(choice);
            }
            for (int i = 0; i < this.maxChoices && i < suppliedChoices.size(); ++i) {
                actualChoices.add(suppliedChoices.get(i));
            }
            choiceCallback.accept(actualChoices);
        });
    }

    @Override
    @NotNull
    public Method getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public MethodRunner getMethodRunner() {
        return this.methodRunner;
    }

    @NotNull
    public MethodParameters<AutocompleteCommandParameter> getParameters() {
        return this.autocompleteParameters;
    }

    @Override
    @NotNull
    public Object getInstance() {
        return this.autocompletionHandler;
    }

    public void checkParameters(SlashCommandInfo info) {
        List<? extends SlashCommandParameter> slashOptions = info.getOptionParameters();
        block0: for (AutocompleteCommandParameter autocompleteParameter : this.autocompleteParameters) {
            if (!autocompleteParameter.isOption()) continue;
            for (SlashCommandParameter slashCommandParameter : slashOptions) {
                if (!slashCommandParameter.getApplicationOptionData().getEffectiveName().equals(autocompleteParameter.getApplicationOptionData().getEffectiveName())) continue;
                this.checkParameter(slashCommandParameter, autocompleteParameter);
                continue block0;
            }
            throw new IllegalArgumentException("Couldn't find parameter named %s in slash command %s".formatted(autocompleteParameter.getApplicationOptionData().getEffectiveName(), Utils.formatMethodShort(info.getMethod())));
        }
    }

    private void checkParameter(SlashCommandParameter slashCommandParameter, AutocompleteCommandParameter autocompleteParameter) {
        Class<?> autocompleteParameterType;
        if (!slashCommandParameter.isOption()) {
            return;
        }
        Class<?> slashParameterType = slashCommandParameter.getBoxedType();
        if (!slashParameterType.equals(autocompleteParameterType = autocompleteParameter.getBoxedType())) {
            throw new IllegalArgumentException("Autocompletion handler parameter #%d does not have the same type as slash command parameter: Provided: %s, correct: %s".formatted(autocompleteParameter.getIndex(), autocompleteParameterType, slashParameterType));
        }
        if (slashCommandParameter.isVarArg() ^ autocompleteParameter.isVarArg()) {
            throw new IllegalArgumentException("Autocompletion handler parameter #%d must be annotated with @%s if the slash command option is too".formatted(autocompleteParameter.getIndex(), VarArgs.class.getSimpleName()));
        }
        if (slashCommandParameter.getVarArgs() != autocompleteParameter.getVarArgs()) {
            throw new IllegalArgumentException("Autocompletion handler parameter #%d must have the same vararg number".formatted(autocompleteParameter.getIndex()));
        }
    }

    public int getMaxChoices() {
        return this.maxChoices;
    }

    public void invalidate() {
        this.cache.invalidate();
    }
}

