/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application.slash.autocomplete;

import com.freya02.botcommands.api.ExceptionHandler;
import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.application.CommandPath;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.RunnableEx;
import com.freya02.botcommands.internal.application.slash.SlashCommandInfo;
import com.freya02.botcommands.internal.application.slash.autocomplete.AutocompletionHandlerInfo;
import com.freya02.botcommands.internal.utils.Utils;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.api.events.GenericEvent;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.hooks.EventListener;
import net.dv8tion.jda.api.hooks.SubscribeEvent;
import net.dv8tion.jda.api.interactions.commands.Command;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class AutocompletionListener
implements EventListener {
    private static final Logger LOGGER = Logging.getLogger();
    private final BContextImpl context;
    private int autocompletionThreadNumber = 0;
    private final ExecutorService autocompletionService = Utils.createCommandPool(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(false);
        thread.setUncaughtExceptionHandler((t, e) -> Utils.printExceptionString("An unexpected exception happened in an autocompletion thread '" + t.getName() + "':", e));
        thread.setName("Autocompletion thread #" + this.autocompletionThreadNumber++);
        return thread;
    });

    public AutocompletionListener(BContextImpl context) {
        this.context = context;
    }

    @SubscribeEvent
    public void onEvent(@NotNull GenericEvent genericEvent) {
        if (genericEvent instanceof CommandAutoCompleteInteractionEvent) {
            CommandAutoCompleteInteractionEvent event = (CommandAutoCompleteInteractionEvent)genericEvent;
            Consumer<Throwable> throwableConsumer = this.getThrowableConsumer(event);
            this.runAutocompletion(() -> {
                SlashCommandInfo slashCommand = this.context.getApplicationCommandsContext().findLiveSlashCommand(event.getGuild(), CommandPath.of(event.getFullCommandName()));
                if (slashCommand == null) {
                    LOGGER.warn("Slash command not found during autocompletion for '{}'", (Object)event.getFullCommandName());
                    return;
                }
                String autocompletionHandler = slashCommand.getAutocompletionHandlerName(event);
                if (autocompletionHandler == null) {
                    LOGGER.warn("Found no autocompletion handler name for option '{}' in command '{}'", (Object)event.getFocusedOption().getName(), (Object)slashCommand.getPath());
                    return;
                }
                AutocompletionHandlerInfo handler = this.context.getAutocompletionHandler(autocompletionHandler);
                if (handler == null) {
                    LOGGER.warn("Found no autocompletion handler for '{}'", (Object)autocompletionHandler);
                    return;
                }
                handler.retrieveChoices(slashCommand, event, throwableConsumer, choices -> event.replyChoices((Collection)choices).queue());
            }, throwableConsumer);
        }
    }

    private void runAutocompletion(RunnableEx code, Consumer<Throwable> throwableConsumer) {
        this.autocompletionService.execute(() -> {
            try {
                code.run();
            }
            catch (Throwable e) {
                throwableConsumer.accept(e);
            }
        });
    }

    private Consumer<Throwable> getThrowableConsumer(CommandAutoCompleteInteractionEvent event) {
        return e -> {
            ExceptionHandler handler = this.context.getUncaughtExceptionHandler();
            if (handler != null) {
                handler.onException(this.context, (Event)event, (Throwable)e);
                return;
            }
            Throwable baseEx = Utils.getException(e);
            Utils.printExceptionString("Unhandled exception in thread '" + Thread.currentThread().getName() + "' while autocompleting a command option '" + this.reconstructCommand(event) + "'", baseEx);
            if (!event.isAcknowledged()) {
                event.replyChoices(new Command.Choice[0]).queue();
            }
            this.context.dispatchException("Exception while autocompleting '" + this.reconstructCommand(event) + "'", baseEx);
        };
    }

    private String reconstructCommand(CommandAutoCompleteInteractionEvent event) {
        return event.getCommandString();
    }
}

