/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application.slash.autocomplete.caches;

import com.freya02.botcommands.api.application.slash.autocomplete.annotations.CacheAutocompletion;
import com.freya02.botcommands.internal.ApplicationOptionData;
import com.freya02.botcommands.internal.application.slash.autocomplete.AutocompleteCommandParameter;
import com.freya02.botcommands.internal.application.slash.autocomplete.AutocompletionHandlerInfo;
import com.freya02.botcommands.internal.application.slash.autocomplete.CompositeAutocompletionKey;
import com.freya02.botcommands.internal.application.slash.autocomplete.caches.AbstractAutocompletionCache;
import java.util.ArrayList;
import java.util.function.ToLongFunction;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import org.jetbrains.annotations.NotNull;

public abstract class BaseAutocompletionCache
extends AbstractAutocompletionCache {
    private final ToLongFunction<CommandAutoCompleteInteractionEvent> guildFunction;
    private final ToLongFunction<CommandAutoCompleteInteractionEvent> channelFunction;
    private final ToLongFunction<CommandAutoCompleteInteractionEvent> userFunction;

    protected BaseAutocompletionCache(@NotNull CacheAutocompletion cacheAutocompletion) {
        this.guildFunction = cacheAutocompletion.guildLocal() ? e -> e.getGuild() != null ? e.getGuild().getIdLong() : 0L : e -> 0L;
        this.channelFunction = cacheAutocompletion.channelLocal() ? e -> e.getChannel() != null ? e.getChannel().getIdLong() : 0L : e -> 0L;
        this.userFunction = cacheAutocompletion.userLocal() ? e -> e.getUser().getIdLong() : e -> 0L;
    }

    private String[] getCompositeOptionValues(AutocompletionHandlerInfo info, CommandAutoCompleteInteractionEvent event) {
        ArrayList<String> optionValues = new ArrayList<String>();
        optionValues.add(event.getName());
        if (event.getSubcommandGroup() != null) {
            optionValues.add(event.getSubcommandGroup());
        }
        if (event.getSubcommandName() != null) {
            optionValues.add(event.getSubcommandName());
        }
        optionValues.add(event.getFocusedOption().getValue());
        for (AutocompleteCommandParameter parameter : info.getParameters()) {
            ApplicationOptionData applicationOptionData = parameter.getApplicationOptionData();
            if (!parameter.isOption()) continue;
            String optionName = applicationOptionData.getEffectiveName();
            if (!parameter.isCompositeKey()) continue;
            OptionMapping option = event.getOption(optionName);
            if (option == null) {
                optionValues.add("null");
                continue;
            }
            if (event.getFocusedOption().getName().equals(optionName)) continue;
            optionValues.add(option.getAsString());
        }
        return optionValues.toArray(new String[0]);
    }

    protected CompositeAutocompletionKey getCompositeKey(AutocompletionHandlerInfo info, CommandAutoCompleteInteractionEvent event) {
        String[] compositeOptionValues = this.getCompositeOptionValues(info, event);
        return new CompositeAutocompletionKey(compositeOptionValues, this.guildFunction.applyAsLong(event), this.channelFunction.applyAsLong(event), this.userFunction.applyAsLong(event));
    }
}

