/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.components.sql;

import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.components.InteractionConstraints;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;

public abstract class SQLComponentData {
    private static final Logger LOGGER = Logging.getLogger();
    private final String componentId;
    private final long groupId;
    private final boolean oneUse;
    private final InteractionConstraints interactionConstraints;
    private final long expirationTimestamp;

    public SQLComponentData(String componentId, long groupId, boolean oneUse, InteractionConstraints interactionConstraints, long expirationTimestamp) {
        this.componentId = componentId;
        this.groupId = groupId;
        this.oneUse = oneUse;
        this.interactionConstraints = interactionConstraints;
        this.expirationTimestamp = expirationTimestamp;
    }

    public void delete(Connection con) throws SQLException {
        if (this.getGroupId() > 0L) {
            try (PreparedStatement preparedStatement = con.prepareStatement("delete from componentdata where groupid = ?;");){
                preparedStatement.setLong(1, this.getGroupId());
                int i = preparedStatement.executeUpdate();
                LOGGER.trace("Deleted {} components from group {}", (Object)i, (Object)this.groupId);
            }
        }
        try (PreparedStatement preparedStatement = con.prepareStatement("delete from componentdata where componentid = ?;");){
            preparedStatement.setString(1, this.getComponentId());
            int i = preparedStatement.executeUpdate();
            if (i > 1) {
                LOGGER.warn("Deleted {} one-use component(s), this should have been only one, component IDs should be unique", (Object)i);
            }
            LOGGER.trace("Deleted component {}", (Object)this.getComponentId());
        }
    }

    public String toString() {
        return "SqlComponentData{componentId='" + this.componentId + "', groupId=" + this.groupId + ", oneUse=" + this.oneUse + ", componentConstraints=" + this.interactionConstraints + ", expirationTimestamp=" + this.expirationTimestamp + "}";
    }

    public String getComponentId() {
        return this.componentId;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public boolean isOneUse() {
        return this.oneUse;
    }

    public InteractionConstraints getInteractionConstraints() {
        return this.interactionConstraints;
    }

    public long getExpirationTimestamp() {
        return this.expirationTimestamp;
    }
}

