/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.components.sql;

import com.freya02.botcommands.api.components.ComponentType;
import com.freya02.botcommands.api.components.InteractionConstraints;
import com.freya02.botcommands.api.components.builder.LambdaComponentTimeoutInfo;
import com.freya02.botcommands.internal.components.sql.SQLComponentData;
import com.freya02.botcommands.internal.components.sql.SQLFetchedComponent;
import com.freya02.botcommands.internal.components.sql.SQLLambdaCreateResult;
import com.freya02.botcommands.internal.utils.Utils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SQLLambdaComponentData
extends SQLComponentData {
    private final long handlerId;

    private SQLLambdaComponentData(String componentId, long groupId, boolean oneUse, InteractionConstraints interactionConstraints, long expirationTimestamp, long handlerId) {
        super(componentId, groupId, oneUse, interactionConstraints, expirationTimestamp);
        this.handlerId = handlerId;
    }

    @NotNull
    public static SQLLambdaComponentData fromFetchedComponent(@NotNull SQLFetchedComponent fetchedComponent) throws SQLException {
        ResultSet resultSet = fetchedComponent.getResultSet();
        return SQLLambdaComponentData.fromResult(resultSet);
    }

    @NotNull
    private static SQLLambdaComponentData fromResult(ResultSet resultSet) throws SQLException {
        return new SQLLambdaComponentData(resultSet.getString("componentId"), resultSet.getLong("groupId"), resultSet.getBoolean("oneUse"), InteractionConstraints.fromJson(resultSet.getString("constraints")), resultSet.getLong("expirationTimestamp"), resultSet.getLong("handlerId"));
    }

    @Nullable
    public static SQLLambdaComponentData read(Connection con, String componentId) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement("select * from lambdacomponentdata join componentdata using(componentid) where componentid = ? limit 1;");){
            SQLLambdaComponentData sQLLambdaComponentData;
            block16: {
                ResultSet resultSet;
                block14: {
                    SQLLambdaComponentData sQLLambdaComponentData2;
                    block15: {
                        preparedStatement.setString(1, componentId);
                        resultSet = preparedStatement.executeQuery();
                        try {
                            if (!resultSet.next()) break block14;
                            sQLLambdaComponentData2 = SQLLambdaComponentData.fromResult(resultSet);
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return sQLLambdaComponentData2;
                }
                sQLLambdaComponentData = null;
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return sQLLambdaComponentData;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SQLLambdaCreateResult create(Connection con, ComponentType type, boolean oneUse, InteractionConstraints constraints, LambdaComponentTimeoutInfo timeout) throws SQLException {
        SQLException lastEx = null;
        int i = 0;
        while (i < 10) {
            long timeoutMillis = timeout.toMillis();
            String randomId = Utils.randomId(64);
            try (PreparedStatement preparedStatement = con.prepareStatement("insert into componentdata (type, componentid, oneuse, constraints, expirationtimestamp) values (?, ?, ?, ?, ?);");){
                preparedStatement.setInt(1, type.getKey());
                preparedStatement.setString(2, randomId);
                preparedStatement.setBoolean(3, oneUse);
                preparedStatement.setString(4, constraints.toJson());
                preparedStatement.setLong(5, timeoutMillis == 0L ? 0L : System.currentTimeMillis() + timeoutMillis);
                preparedStatement.execute();
                try (PreparedStatement preparedStatement1 = con.prepareStatement("insert into lambdacomponentdata (componentid) values (?) returning handlerid;");){
                    preparedStatement1.setString(1, randomId);
                    try (ResultSet resultSet = preparedStatement1.executeQuery();){
                        if (!resultSet.next()) throw new IllegalStateException("Lambda component insert into didn't return the handler id");
                        SQLLambdaCreateResult sQLLambdaCreateResult = new SQLLambdaCreateResult(randomId, resultSet.getLong("handlerId"));
                        return sQLLambdaCreateResult;
                    }
                }
            }
            catch (SQLException ex) {
                lastEx = ex;
                ++i;
            }
        }
        throw new SQLException("Could not insert a random component ID after 10 tries, maybe the database is full of IDs ?", lastEx);
    }

    public long getHandlerId() {
        return this.handlerId;
    }

    @Override
    public String toString() {
        return "SqlLambdaComponentData{handlerId=" + this.handlerId + "} " + super.toString();
    }
}

