/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.localization;

import com.freya02.botcommands.api.localization.GuildLocalizable;
import com.freya02.botcommands.api.localization.Localizable;
import com.freya02.botcommands.api.localization.Localization;
import com.freya02.botcommands.api.localization.LocalizationTemplate;
import com.freya02.botcommands.api.localization.UserLocalizable;
import com.freya02.botcommands.api.localization.annotations.LocalizationBundle;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.LocalizationManager;
import java.lang.reflect.Method;
import java.util.Locale;
import net.dv8tion.jda.api.interactions.DiscordLocale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLocalizer
implements UserLocalizable,
GuildLocalizable,
Localizable {
    private final BContextImpl context;
    private final Method method;
    private final DiscordLocale guildLocale;
    private final DiscordLocale userLocale;

    public EventLocalizer(@NotNull BContextImpl context, @Nullable Method method, @Nullable DiscordLocale guildLocale, @Nullable DiscordLocale userLocale) {
        this.context = context;
        this.method = method;
        this.guildLocale = guildLocale;
        this.userLocale = userLocale;
    }

    @Override
    @NotNull
    public String localize(@NotNull DiscordLocale locale, @NotNull String localizationBundle, @NotNull String localizationPath, Localization.Entry ... entries) {
        String localizationPrefix;
        LocalizationManager localizationManager = this.context.getLocalizationManager();
        Localization instance = Localization.getInstance(localizationBundle, Locale.forLanguageTag(locale.getLocale()));
        if (instance == null) {
            throw new IllegalArgumentException("Found no localization instance for bundle '%s' and locale '%s'".formatted(localizationBundle, locale));
        }
        Object effectivePath = this.method != null ? ((localizationPrefix = localizationManager.getLocalizationPrefix(this.method)) == null ? localizationPath : localizationPrefix + "." + localizationPath) : localizationPath;
        LocalizationTemplate template = instance.get((String)effectivePath);
        if (template == null) {
            throw new IllegalArgumentException("Found no localization template for '%s' (in bundle '%s' with locale '%s')".formatted(effectivePath, localizationBundle, instance.getEffectiveLocale()));
        }
        return template.localize(entries);
    }

    @Override
    @NotNull
    public String localize(@NotNull String localizationBundle, @NotNull String localizationPath, Localization.Entry ... entries) {
        if (this.userLocale != null) {
            return this.localizeUser(localizationPath, localizationBundle, entries);
        }
        if (this.guildLocale != null) {
            return this.localizeGuild(localizationPath, localizationBundle, entries);
        }
        return this.localize(DiscordLocale.ENGLISH_US, localizationBundle, localizationPath, entries);
    }

    @Override
    @NotNull
    public String localize(@NotNull DiscordLocale locale, @NotNull String localizationPath, Localization.Entry ... entries) {
        return this.localize(locale, this.getLocalizationBundle(), localizationPath, entries);
    }

    @Override
    @NotNull
    public String localize(@NotNull String localizationPath, Localization.Entry ... entries) {
        if (this.userLocale != null) {
            return this.localizeUser(localizationPath, entries);
        }
        if (this.guildLocale != null) {
            return this.localizeGuild(localizationPath, entries);
        }
        return this.localize(DiscordLocale.ENGLISH_US, localizationPath, entries);
    }

    @Override
    @NotNull
    public String getLocalizationBundle() {
        if (this.method == null) {
            throw new IllegalStateException("Cannot use predefined localization bundles in this event");
        }
        String localizationBundle = this.context.getLocalizationManager().getLocalizationBundle(this.method);
        if (localizationBundle == null) {
            throw new IllegalArgumentException("You cannot use this localization method without having the command, or the class which contains it, be annotated with @" + LocalizationBundle.class.getSimpleName());
        }
        return localizationBundle;
    }

    @Override
    @NotNull
    public DiscordLocale getGuildLocale() {
        if (this.guildLocale == null) {
            throw new IllegalStateException("Cannot guild localize on an event which doesn't provide guild localization");
        }
        return this.guildLocale;
    }

    @Override
    @NotNull
    public DiscordLocale getUserLocale() {
        if (this.userLocale == null) {
            throw new IllegalStateException("Cannot guild localize on an event which doesn't provide guild localization");
        }
        return this.userLocale;
    }
}

