/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.modals;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.modals.annotations.ModalHandler;
import com.freya02.botcommands.api.parameters.ModalParameterResolver;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.ExecutableInteractionInfo;
import com.freya02.botcommands.internal.MethodParameters;
import com.freya02.botcommands.internal.modals.InputData;
import com.freya02.botcommands.internal.modals.ModalData;
import com.freya02.botcommands.internal.modals.ModalHandlerParameter;
import com.freya02.botcommands.internal.runner.MethodRunner;
import com.freya02.botcommands.internal.utils.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.api.events.interaction.ModalInteractionEvent;
import net.dv8tion.jda.api.interactions.modals.ModalMapping;
import org.jetbrains.annotations.NotNull;

public class ModalHandlerInfo
implements ExecutableInteractionInfo {
    private final Object autocompletionHandler;
    private final Method method;
    private final MethodRunner methodRunner;
    private final String handlerName;
    private final MethodParameters<ModalHandlerParameter> modalParameters;

    public ModalHandlerInfo(BContextImpl context, Object autocompletionHandler, Method method) {
        this.autocompletionHandler = autocompletionHandler;
        this.method = method;
        this.methodRunner = context.getMethodRunnerFactory().make(autocompletionHandler, method);
        ModalHandler annotation = method.getAnnotation(ModalHandler.class);
        this.handlerName = annotation.name();
        this.modalParameters = MethodParameters.of(context, method, ModalHandlerParameter::new);
        boolean hasModalData = this.modalParameters.stream().anyMatch(ModalHandlerParameter::isModalData);
        if (hasModalData) {
            boolean sawModalData = false;
            for (ModalHandlerParameter parameter : this.modalParameters) {
                if (!parameter.isModalData() && !sawModalData) {
                    throw new IllegalArgumentException("Parameter #%d at %s must be annotated with @%s or situated after all modal data parameters.\nAll modal data must be inserted after the event, with the same order as the constructed modal, before inserting modal inputs and custom parameters".formatted(parameter.getIndex(), Utils.formatMethodShort(method), ModalData.class.getSimpleName()));
                }
                if (!parameter.isModalData()) continue;
                sawModalData = true;
            }
        }
    }

    @Override
    @NotNull
    public Method getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public MethodRunner getMethodRunner() {
        return this.methodRunner;
    }

    @NotNull
    public MethodParameters<ModalHandlerParameter> getParameters() {
        return this.modalParameters;
    }

    @Override
    @NotNull
    public Object getInstance() {
        return this.autocompletionHandler;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public boolean execute(BContext context, ModalData modalData, ModalInteractionEvent event, Consumer<Throwable> throwableConsumer) throws Exception {
        Map<String, InputData> inputDataMap = modalData.getInputDataMap();
        HashMap inputNameToInputIdMap = new HashMap();
        inputDataMap.forEach((inputId, inputData) -> inputNameToInputIdMap.put(inputData.getInputName(), inputId));
        ArrayList<Object> objects = new ArrayList<Object>(this.modalParameters.size() + 1);
        objects.add(event);
        Object[] userData = modalData.getUserData();
        long expectedModalDatas = this.modalParameters.stream().filter(ModalHandlerParameter::isModalData).count();
        long expectedModalInputs = this.modalParameters.stream().filter(ModalHandlerParameter::isModalInput).count();
        if (expectedModalDatas != (long)userData.length || expectedModalInputs != (long)event.getValues().size()) {
            throw new IllegalArgumentException("Modal handler at %s does not match the received modal data:\nMethod signature: %d userdata parameters and %d modal input(s)\nDiscord data: %d userdata parameters and %d modal input(s)".formatted(Utils.formatMethodShort(this.method), expectedModalDatas, expectedModalInputs, userData.length, event.getValues().size()));
        }
        for (int i = 0; i < userData.length; ++i) {
            ModalHandlerParameter parameter = (ModalHandlerParameter)this.modalParameters.get(i);
            if (!parameter.isModalData()) {
                throw new IllegalArgumentException("Parameter #%d at %s must be annotated with @%s or situated after all modal data parameters.\nAll modal data must be inserted after the event, with the same order as the constructed modal, before inserting modal inputs and custom parameters".formatted(i, Utils.formatMethodShort(this.method), ModalData.class.getSimpleName()));
            }
            Object data = userData[i];
            if (data != null && !parameter.getBoxedType().isAssignableFrom(data.getClass())) {
                throw new IllegalArgumentException("The modal user data '%s' is not a valid type (expected a %s, got a %s)".formatted(parameter.getParameter().getName(), parameter.getBoxedType().getSimpleName(), data.getClass().getSimpleName()));
            }
            objects.add(data);
        }
        for (ModalHandlerParameter parameter : this.modalParameters) {
            Object obj;
            if (parameter.isModalData()) continue;
            if (parameter.isOption() && parameter.isModalInput()) {
                String inputId2 = (String)inputNameToInputIdMap.get(parameter.getModalInputName());
                if (inputId2 == null) {
                    throw new IllegalArgumentException(String.format("Modal input '%s' was not found", parameter.getModalInputName()));
                }
                ModalMapping modalMapping = event.getValue(inputId2);
                if (modalMapping == null) {
                    throw new IllegalArgumentException("Modal input '%s' was not found".formatted(parameter.getModalInputName()));
                }
                obj = ((ModalParameterResolver)parameter.getResolver()).resolve(context, this, event, modalMapping);
                if (obj == null) {
                    throw new IllegalArgumentException("The parameter '%s' of value '%s' could not be resolved into a %s".formatted(parameter.getParameter().getName(), modalMapping.getAsString(), parameter.getBoxedType().getSimpleName()));
                }
                if (!parameter.getBoxedType().isAssignableFrom(obj.getClass())) {
                    throw new IllegalArgumentException("The parameter '%s' of value '%s' is not a valid type (expected a %s)".formatted(parameter.getParameter().getName(), modalMapping.getAsString(), parameter.getBoxedType().getSimpleName()));
                }
            } else {
                obj = parameter.getCustomResolver().resolve(context, this, (Event)event);
            }
            objects.add(obj);
        }
        this.getMethodRunner().invoke(objects.toArray(), throwableConsumer);
        return true;
    }
}

