/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.modals;

import com.freya02.botcommands.api.ExceptionHandler;
import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.RunnableEx;
import com.freya02.botcommands.internal.modals.ModalData;
import com.freya02.botcommands.internal.modals.ModalHandlerInfo;
import com.freya02.botcommands.internal.modals.ModalMaps;
import com.freya02.botcommands.internal.utils.Utils;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.api.events.GenericEvent;
import net.dv8tion.jda.api.events.interaction.ModalInteractionEvent;
import net.dv8tion.jda.api.hooks.EventListener;
import net.dv8tion.jda.api.hooks.SubscribeEvent;
import net.dv8tion.jda.api.interactions.Interaction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ModalListener
implements EventListener {
    private static final Logger LOGGER = Logging.getLogger();
    private final BContextImpl context;
    private int commandThreadNumber = 0;
    private final ExecutorService commandService = Utils.createCommandPool(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(false);
        thread.setUncaughtExceptionHandler((t, e) -> Utils.printExceptionString("An unexpected exception happened in a modal handling thread '" + t.getName() + "':", e));
        thread.setName("Modal handling thread #" + this.commandThreadNumber++);
        return thread;
    });

    public ModalListener(BContextImpl context) {
        this.context = context;
    }

    @SubscribeEvent
    public void onEvent(@NotNull GenericEvent e) {
        if (e instanceof ModalInteractionEvent) {
            ModalInteractionEvent event = (ModalInteractionEvent)e;
            Consumer<Throwable> throwableConsumer = this.getThrowableConsumer(event);
            this.runCommand(() -> {
                ModalData modalData = this.context.getModalMaps().consumeModal(event.getModalId());
                if (modalData == null) {
                    if (!ModalMaps.hasBeenUsed) {
                        LOGGER.error("Tried to handle a modal that was not constructed with the framework, you need to use the Modals class to make modals/text inputs");
                        event.reply(this.context.getDefaultMessages((Interaction)event).getGeneralErrorMsg()).setEphemeral(true).queue();
                    } else {
                        event.reply(this.context.getDefaultMessages((Interaction)event).getModalExpiredErrorMsg()).setEphemeral(true).queue();
                    }
                    return;
                }
                ModalHandlerInfo modalHandler = this.context.getApplicationCommandsContext().getModalHandler(modalData.getHandlerName());
                if (modalHandler == null) {
                    throw new IllegalArgumentException("Got no modal handler for handler name: '%s'".formatted(modalData.getHandlerName()));
                }
                modalHandler.execute(this.context, modalData, event, throwableConsumer);
            }, throwableConsumer);
        }
    }

    private Consumer<Throwable> getThrowableConsumer(ModalInteractionEvent event) {
        return e -> {
            ExceptionHandler handler = this.context.getUncaughtExceptionHandler();
            if (handler != null) {
                handler.onException(this.context, (Event)event, (Throwable)e);
                return;
            }
            Throwable baseEx = Utils.getException(e);
            Utils.printExceptionString("Unhandled exception in thread '" + Thread.currentThread().getName() + "' while executing a modal handler", baseEx);
            if (event.isAcknowledged()) {
                event.getHook().sendMessage(this.context.getDefaultMessages(event.getGuild()).getGeneralErrorMsg()).setEphemeral(true).queue();
            } else {
                event.reply(this.context.getDefaultMessages(event.getGuild()).getGeneralErrorMsg()).setEphemeral(true).queue();
            }
            this.context.dispatchException("Exception in modal handler", baseEx);
        };
    }

    private void runCommand(RunnableEx code, Consumer<Throwable> throwableConsumer) {
        this.commandService.execute(() -> {
            try {
                code.run();
            }
            catch (Throwable e) {
                throwableConsumer.accept(e);
            }
        });
    }
}

