/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.modals;

import com.freya02.botcommands.internal.modals.InputData;
import com.freya02.botcommands.internal.modals.ModalData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import org.jetbrains.annotations.Nullable;

public class ModalMaps {
    public static boolean hasBeenUsed = false;
    private static final ScheduledExecutorService TIMEOUT_SERVICE = Executors.newSingleThreadScheduledExecutor();
    private static final long MAX_ID = Long.MAX_VALUE;
    private static final long MIN_ID = (long)Math.pow(10.0, Math.floor(Math.log10(9.223372036854776E18)));
    private final Map<String, ModalData> modalMap = new HashMap<String, ModalData>();
    private final Map<String, InputData> inputMap = new HashMap<String, InputData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String nextModalId() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        Map<String, ModalData> map = this.modalMap;
        synchronized (map) {
            String id;
            while (this.modalMap.containsKey(id = String.valueOf(random.nextLong(MIN_ID, Long.MAX_VALUE)))) {
            }
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String insertModal(ModalData data, String id) {
        if (!hasBeenUsed) {
            hasBeenUsed = true;
        }
        Map<String, ModalData> map = this.modalMap;
        synchronized (map) {
            if (id == null || id.equals("0")) {
                id = this.nextModalId();
            }
            this.modalMap.put(id, data);
            if (data.getTimeoutInfo() != null) {
                String finalId = id;
                ScheduledFuture<?> future = TIMEOUT_SERVICE.schedule(() -> {
                    Map<String, ModalData> map = this.modalMap;
                    synchronized (map) {
                        if (this.modalMap.remove(finalId) != null) {
                            data.getTimeoutInfo().onTimeout().run();
                        }
                    }
                }, data.getTimeoutInfo().timeout(), data.getTimeoutInfo().unit());
                data.setTimeoutFuture(future);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ModalData consumeModal(String modalId) {
        Map<String, ModalData> map = this.modalMap;
        synchronized (map) {
            ModalData data = this.modalMap.remove(modalId);
            if (data != null) {
                data.cancelTimeoutFuture();
            }
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String nextInputId() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        Map<String, InputData> map = this.inputMap;
        synchronized (map) {
            String id;
            while (this.inputMap.containsKey(id = String.valueOf(random.nextLong(MIN_ID, Long.MAX_VALUE)))) {
            }
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String insertInput(InputData data, String id) {
        if (!hasBeenUsed) {
            hasBeenUsed = true;
        }
        Map<String, InputData> map = this.inputMap;
        synchronized (map) {
            if (id == null || id.equals("0")) {
                id = this.nextInputId();
            }
            this.inputMap.put(id, data);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public InputData removeInput(String inputId) {
        Map<String, InputData> map = this.inputMap;
        synchronized (map) {
            return this.inputMap.remove(inputId);
        }
    }
}

