/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.parameters;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.parameters.ComponentParameterResolver;
import com.freya02.botcommands.api.parameters.ParameterResolver;
import com.freya02.botcommands.api.parameters.RegexParameterResolver;
import com.freya02.botcommands.api.parameters.SlashParameterResolver;
import com.freya02.botcommands.internal.application.slash.SlashCommandInfo;
import com.freya02.botcommands.internal.components.ComponentDescriptor;
import com.freya02.botcommands.internal.prefixed.TextCommandInfo;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.events.interaction.component.GenericComponentInteractionCreateEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.interactions.commands.CommandInteractionPayload;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanResolver
extends ParameterResolver
implements RegexParameterResolver,
SlashParameterResolver,
ComponentParameterResolver {
    public BooleanResolver() {
        super(Boolean.class);
    }

    @Override
    @Nullable
    public Object resolve(@NotNull BContext context, @NotNull TextCommandInfo info, @NotNull MessageReceivedEvent event, @NotNull @NotNull String @NotNull [] args) {
        return this.parseBoolean(args[0]);
    }

    @Override
    @NotNull
    public Pattern getPattern() {
        return Pattern.compile("(true|false)", 2);
    }

    @Override
    @NotNull
    public String getTestExample() {
        return "true";
    }

    @Override
    @NotNull
    public OptionType getOptionType() {
        return OptionType.BOOLEAN;
    }

    @Override
    @Nullable
    public Object resolve(@NotNull BContext context, @NotNull SlashCommandInfo info, @NotNull CommandInteractionPayload event, @NotNull OptionMapping optionMapping) {
        return optionMapping.getAsBoolean();
    }

    @Override
    @Nullable
    public Object resolve(@NotNull BContext context, @NotNull ComponentDescriptor descriptor, @NotNull GenericComponentInteractionCreateEvent event, @NotNull String arg) {
        return this.parseBoolean(arg);
    }

    @Nullable
    private Object parseBoolean(String arg) {
        if (arg.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (arg.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        return null;
    }
}

