/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.prefixed;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.prefixed.BaseCommandEvent;
import com.freya02.botcommands.api.utils.EmojiUtils;
import com.freya02.botcommands.internal.BContextImpl;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.utils.FileUpload;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BaseCommandEventImpl
extends BaseCommandEvent {
    public static final Emoji SUCCESS = EmojiUtils.resolveJDAEmoji(":white_check_mark:");
    public static final Emoji ERROR = EmojiUtils.resolveJDAEmoji(":x:");
    private static final Logger LOGGER = Logging.getLogger();
    protected final BContext context;
    protected final String argumentsStr;
    protected final GuildMessageChannel channel;

    public BaseCommandEventImpl(@NotNull BContextImpl context, @Nullable Method method, MessageReceivedEvent event, String arguments) {
        super(context, method, event.getJDA(), event.getResponseNumber(), event.getMessage());
        this.context = context;
        this.argumentsStr = arguments;
        this.channel = event.getGuildChannel();
    }

    @Override
    public BContext getContext() {
        return this.context;
    }

    @Override
    public List<String> getArgumentsStrList() {
        if (!this.argumentsStr.isBlank()) {
            return Arrays.asList(this.argumentsStr.split(" "));
        }
        return List.of();
    }

    @Override
    public String getArgumentsStr() {
        return this.argumentsStr;
    }

    @Override
    public void reportError(String message, Throwable e) {
        this.channel.sendMessage((CharSequence)message).queue(null, t -> LOGGER.error("Could not send message to channel : {}", (Object)message));
        this.context.dispatchException(message, e);
    }

    @Override
    public Consumer<? super Throwable> failureReporter(String message) {
        return t -> this.reportError(message, (Throwable)t);
    }

    @Override
    public String getAuthorBestName() {
        return this.getMember().getEffectiveName();
    }

    @Override
    @NotNull
    public EmbedBuilder getDefaultEmbed() {
        return this.context.getDefaultEmbedSupplier().get();
    }

    @Override
    @Nullable
    public InputStream getDefaultIconStream() {
        return this.context.getDefaultFooterIconSupplier().get();
    }

    @Override
    public RestAction<Message> sendWithEmbedFooterIcon(MessageEmbed embed, Consumer<? super Throwable> onException) {
        return this.sendWithEmbedFooterIcon((MessageChannel)this.channel, embed, onException);
    }

    @Override
    @CheckReturnValue
    public RestAction<Message> sendWithEmbedFooterIcon(MessageChannel channel, MessageEmbed embed, Consumer<? super Throwable> onException) {
        return this.sendWithEmbedFooterIcon(channel, this.getDefaultIconStream(), embed, onException);
    }

    @Override
    @CheckReturnValue
    public RestAction<Message> sendWithEmbedFooterIcon(MessageChannel channel, InputStream iconStream, MessageEmbed embed, Consumer<? super Throwable> onException) {
        if (iconStream != null) {
            return channel.sendTyping().flatMap(v -> (RestAction)channel.sendFiles(new FileUpload[]{FileUpload.fromData((InputStream)iconStream, (String)"icon.jpg")}).setEmbeds(new MessageEmbed[]{embed}));
        }
        return channel.sendTyping().flatMap(v -> channel.sendMessageEmbeds(embed, new MessageEmbed[0]));
    }

    @Override
    @CheckReturnValue
    public RestAction<Void> reactSuccess() {
        return this.channel.addReactionById(this.messageId, SUCCESS);
    }

    @Override
    @CheckReturnValue
    public RestAction<Void> reactError() {
        return this.channel.addReactionById(this.messageId, ERROR);
    }

    @Override
    @NotNull
    public RestAction<Message> respond(@NotNull CharSequence text) {
        return this.channel.sendMessage(text);
    }

    @Override
    @NotNull
    public RestAction<Message> respondFormat(@NotNull String format, Object ... args) {
        return this.channel.sendMessageFormat(format, args);
    }

    @Override
    @NotNull
    public RestAction<Message> respond(@NotNull MessageEmbed embed, MessageEmbed ... other) {
        return this.channel.sendMessageEmbeds(embed, other);
    }

    @Override
    @NotNull
    public RestAction<Message> respondFile(FileUpload ... fileUploads) {
        return this.channel.sendFiles(fileUploads);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public RestAction<Message> reply(@NotNull CharSequence text) {
        return this.getMessage().reply(text);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public RestAction<Message> replyFormat(@NotNull String format, Object ... args) {
        return this.getMessage().replyFormat(format, args);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public RestAction<Message> reply(@NotNull MessageEmbed embed, MessageEmbed ... other) {
        return this.getMessage().replyEmbeds(embed, other);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public RestAction<Message> replyFile(FileUpload ... fileUploads) {
        return this.channel.sendTyping().flatMap(v -> this.getMessage().replyFiles(fileUploads));
    }

    @Override
    @NotNull
    public RestAction<Message> indicateError(@NotNull CharSequence text) {
        if (this.getGuild().getSelfMember().hasPermission((GuildChannel)this.channel, new Permission[]{Permission.MESSAGE_ADD_REACTION})) {
            return this.reactError().flatMap(v -> this.channel.sendMessage(text));
        }
        return this.channel.sendMessage(text);
    }

    @Override
    @NotNull
    public RestAction<Message> indicateErrorFormat(@NotNull String format, Object ... args) {
        if (this.getGuild().getSelfMember().hasPermission((GuildChannel)this.channel, new Permission[]{Permission.MESSAGE_ADD_REACTION})) {
            return this.reactError().flatMap(v -> this.channel.sendMessageFormat(format, args));
        }
        return this.channel.sendMessageFormat(format, args);
    }

    @Override
    @NotNull
    public RestAction<Message> indicateError(@NotNull MessageEmbed embed, MessageEmbed ... other) {
        if (this.getGuild().getSelfMember().hasPermission((GuildChannel)this.channel, new Permission[]{Permission.MESSAGE_ADD_REACTION})) {
            return this.reactError().flatMap(v -> this.channel.sendMessageEmbeds(embed, other));
        }
        return this.channel.sendMessageEmbeds(embed, other);
    }
}

