/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.prefixed;

import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.prefixed.CommandEvent;
import com.freya02.botcommands.api.prefixed.exceptions.BadIdException;
import com.freya02.botcommands.api.prefixed.exceptions.NoIdException;
import com.freya02.botcommands.api.utils.RichTextFinder;
import com.freya02.botcommands.api.utils.RichTextType;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.prefixed.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.entities.IMentionable;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.emoji.CustomEmoji;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.emoji.UnicodeEmoji;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.exceptions.ErrorResponseException;
import net.dv8tion.jda.api.requests.ErrorResponse;
import net.dv8tion.jda.internal.utils.Helpers;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class CommandEventImpl
extends CommandEvent {
    private static final Pattern idPattern = Pattern.compile("(\\d+)");
    private static final Logger LOGGER = Logging.getLogger();
    private final List<Object> arguments = new ArrayList<Object>();
    private final MessageReceivedEvent event;

    public CommandEventImpl(@NotNull BContextImpl context, @NotNull Method method, MessageReceivedEvent event, String arguments) {
        super(method, context, event, arguments);
        this.event = event;
        new RichTextFinder(arguments, true, false, true, false).processResults(this::processText);
    }

    private static IMentionable tryGetId(String mention, Function<Long, IMentionable> idToMentionableFunc) {
        Matcher matcher = idPattern.matcher(mention);
        if (matcher.find()) {
            return idToMentionableFunc.apply(Long.valueOf(matcher.group()));
        }
        return null;
    }

    @Override
    public List<Object> getArguments() {
        return this.arguments;
    }

    @Override
    public <T> boolean hasNext(Class<T> clazz) {
        if (this.arguments.isEmpty()) {
            return false;
        }
        Object o = this.arguments.get(0);
        return clazz.isAssignableFrom(o.getClass());
    }

    @Override
    public <T> T peekArgument(Class<T> clazz) {
        if (this.arguments.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object o = this.arguments.get(0);
        if (clazz.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        throw new NoSuchElementException();
    }

    @Override
    @NotNull
    public <T> T nextArgument(Class<T> clazz) {
        if (this.arguments.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object o = this.arguments.remove(0);
        if (clazz.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        throw new NoSuchElementException();
    }

    @Override
    @NotNull
    public <T extends IMentionable> T resolveNext(Class<?> ... classes) throws NoIdException, BadIdException {
        if (this.arguments.isEmpty()) {
            throw new NoIdException();
        }
        Object o = this.arguments.remove(0);
        for (Class<?> c : classes) {
            if (!c.isAssignableFrom(o.getClass())) continue;
            return (T)((IMentionable)o);
        }
        if (!(o instanceof String)) {
            throw new NoIdException();
        }
        String idStr = (String)o;
        for (Class<?> clazz : classes) {
            try {
                Role mentionable;
                if (idStr.length() > 20 || !Helpers.isNumeric((String)idStr)) {
                    throw new BadIdException();
                }
                long id = Long.parseLong(idStr);
                if (clazz == Role.class) {
                    mentionable = this.getGuild().getRoleById(id);
                } else if (clazz == User.class) {
                    mentionable = Utils.findEntity(id, this.event.getMessage().getMentions().getUsers(), () -> (User)this.getJDA().retrieveUserById(id).complete());
                } else if (clazz == Member.class) {
                    mentionable = Utils.findEntity(id, this.event.getMessage().getMentions().getMembers(), () -> (Member)this.getGuild().retrieveMemberById(id).complete());
                } else if (clazz == TextChannel.class) {
                    mentionable = this.getGuild().getTextChannelById(id);
                } else if (clazz == CustomEmoji.class) {
                    mentionable = this.getJDA().getEmojiById(id);
                } else {
                    throw new IllegalArgumentException(clazz.getSimpleName() + " is not a valid IMentionable class");
                }
                if (mentionable == null) continue;
                return (T)mentionable;
            }
            catch (NumberFormatException ignored) {
                throw new BadIdException();
            }
            catch (ErrorResponseException e) {
                if (e.getErrorResponse() == ErrorResponse.UNKNOWN_USER || e.getErrorResponse() == ErrorResponse.UNKNOWN_MEMBER) {
                    throw new BadIdException();
                }
                throw e;
            }
        }
        throw new BadIdException();
    }

    private void processText(String substring, RichTextType type) {
        if (substring.isBlank()) {
            return;
        }
        Message.MentionType mentionType = type.getMentionType();
        if (mentionType != null || type == RichTextType.UNICODE_EMOTE) {
            UnicodeEmoji mentionable = null;
            if (type == RichTextType.UNICODE_EMOTE) {
                mentionable = Emoji.fromUnicode((String)substring);
            } else if (mentionType == Message.MentionType.ROLE) {
                mentionable = CommandEventImpl.tryGetId(substring, id -> this.getGuild().getRoleById(id.longValue()));
            } else if (mentionType == Message.MentionType.CHANNEL) {
                mentionable = CommandEventImpl.tryGetId(substring, id -> this.getGuild().getTextChannelById(id.longValue()));
            } else if (mentionType == Message.MentionType.EMOJI) {
                Matcher matcher = Message.MentionType.EMOJI.getPattern().matcher(substring);
                if (matcher.find()) {
                    String id2 = matcher.group(2);
                    mentionable = this.getGuild().getEmojiById(id2);
                }
            } else if (mentionType == Message.MentionType.USER) {
                mentionable = CommandEventImpl.tryGetId(substring, id -> this.getJDA().getUserById(id.longValue()));
            }
            if (mentionable != null) {
                this.arguments.add(mentionable);
            } else {
                LOGGER.error("Unresolved mentionable : '{}' of type {}, maybe you haven't enabled a cache flag / intent ?", (Object)substring, (Object)type.name());
            }
        } else if (!substring.isEmpty()) {
            Collections.addAll(this.arguments, substring.split(" "));
        }
    }
}

