/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.prefixed;

import com.freya02.botcommands.api.CooldownScope;
import com.freya02.botcommands.api.DefaultMessages;
import com.freya02.botcommands.api.ExceptionHandler;
import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.SettingsProvider;
import com.freya02.botcommands.api.application.CommandPath;
import com.freya02.botcommands.api.prefixed.IHelpCommand;
import com.freya02.botcommands.api.prefixed.TextCommandFilter;
import com.freya02.botcommands.api.prefixed.TextFilteringData;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.RunnableEx;
import com.freya02.botcommands.internal.Usability;
import com.freya02.botcommands.internal.prefixed.BaseCommandEventImpl;
import com.freya02.botcommands.internal.prefixed.ExecutionResult;
import com.freya02.botcommands.internal.prefixed.TextCommandCandidates;
import com.freya02.botcommands.internal.prefixed.TextCommandInfo;
import com.freya02.botcommands.internal.utils.Utils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.xdrop.fuzzywuzzy.FuzzySearch;
import me.xdrop.fuzzywuzzy.model.ExtractedResult;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.IMentionable;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.exceptions.ErrorHandler;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.hooks.SubscribeEvent;
import net.dv8tion.jda.api.requests.ErrorResponse;
import net.dv8tion.jda.internal.requests.CompletedRestAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class CommandListener
extends ListenerAdapter {
    private static final Logger LOGGER = Logging.getLogger();
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+");
    private final BContextImpl context;
    private final boolean pingAsPrefix;
    private final TextCommandInfo helpInfo;
    private final IHelpCommand helpCommand;
    private int commandThreadNumber = 0;
    private final ExecutorService commandService = Utils.createCommandPool(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(false);
        thread.setUncaughtExceptionHandler((t, e) -> Utils.printExceptionString("An unexpected exception happened in command thread '" + t.getName() + "':", e));
        thread.setName("Command thread #" + this.commandThreadNumber++);
        return thread;
    });

    public CommandListener(BContextImpl context, boolean pingAsPrefix) {
        this.context = context;
        this.pingAsPrefix = pingAsPrefix;
        TextCommandInfo helpCommandInfo = context.findFirstCommand(CommandPath.ofName("help"));
        if (helpCommandInfo == null) {
            LOGGER.debug("Help command not loaded");
            this.helpInfo = null;
            this.helpCommand = null;
        } else {
            this.helpInfo = helpCommandInfo;
            Object t = this.helpInfo.getInstance();
            if (!(t instanceof IHelpCommand)) {
                throw new IllegalStateException("Help command must implement IHelpCommand");
            }
            IHelpCommand helpCmd = (IHelpCommand)t;
            this.helpCommand = helpCmd;
        }
    }

    @Nullable
    private String getMsgNoPrefix(String msg, Guild guild) {
        int prefixLength = -1;
        for (String prefix : this.getPrefixes(guild)) {
            if (!msg.startsWith(prefix)) continue;
            prefixLength = prefix.length();
            break;
        }
        if (prefixLength == -1) {
            return null;
        }
        return msg.substring(prefixLength).trim();
    }

    private List<String> getPrefixes(Guild guild) {
        SettingsProvider settingsProvider = this.context.getSettingsProvider();
        if (settingsProvider != null) {
            List<String> prefixes = settingsProvider.getPrefixes(guild);
            if (prefixes == null || prefixes.isEmpty()) {
                return this.context.getPrefixes();
            }
            return prefixes;
        }
        return this.context.getPrefixes();
    }

    @SubscribeEvent
    public void onMessageReceived(MessageReceivedEvent event) {
        if (!event.isFromGuild()) {
            return;
        }
        if (event.getAuthor().isBot() || event.isWebhookMessage()) {
            return;
        }
        Member member = event.getMember();
        if (member == null) {
            LOGGER.error("Command caller member is null ! This shouldn't happen if the message isn't a webhook, or is the docs wrong ?");
            return;
        }
        if (this.pingAsPrefix && !event.getMessage().getMentions().isMentioned((IMentionable)event.getJDA().getSelfUser(), new Message.MentionType[0])) {
            return;
        }
        String msg = event.getMessage().getContentRaw();
        Consumer<Throwable> throwableConsumer = this.getThrowableConsumer(event, msg);
        this.runCommand(() -> {
            boolean isNotOwner;
            String msgNoPrefix = this.getMsgNoPrefix(msg, event.getGuild());
            if (msgNoPrefix == null || msgNoPrefix.isBlank()) {
                return;
            }
            LOGGER.trace("Received prefixed command: {}", (Object)msg);
            String[] split = SPACE_PATTERN.split(msgNoPrefix, 4);
            TextCommandCandidates candidates = this.getCommandCandidates(Arrays.copyOf(split, 3));
            boolean bl = isNotOwner = !this.context.isOwner(member.getIdLong());
            if (candidates == null) {
                this.onCommandNotFound(event, CommandPath.of(split[0]), isNotOwner);
                return;
            }
            int count = candidates.findFirst().getPath().getNameCount();
            String args = Arrays.stream(split).skip(count).collect(Collectors.joining(" "));
            for (TextCommandInfo candidate : candidates) {
                Matcher matcher;
                Pattern pattern = candidate.getCompletePattern();
                if (!(pattern != null ? (matcher = pattern.matcher(args)).matches() && this.tryExecute(event, member, isNotOwner, args, candidate, matcher, throwableConsumer) != ExecutionResult.CONTINUE : this.tryExecute(event, member, isNotOwner, args, candidate, null, throwableConsumer) != ExecutionResult.CONTINUE)) continue;
                return;
            }
            if (this.helpCommand != null) {
                this.helpCommand.onInvalidCommand(new BaseCommandEventImpl(this.context, this.helpInfo.getMethod(), event, ""), ((TextCommandInfo)candidates.first()).getPath());
            }
        }, throwableConsumer);
    }

    private ExecutionResult tryExecute(MessageReceivedEvent event, Member member, boolean isNotOwner, String args, TextCommandInfo candidate, Matcher matcher, Consumer<Throwable> throwableConsumer) throws Exception {
        long cooldown;
        TextFilteringData filteringData = new TextFilteringData(this.context, event, candidate, args);
        for (TextCommandFilter filter : this.context.getTextFilters()) {
            if (filter.isAccepted(filteringData)) continue;
            LOGGER.trace("Cancelled prefixed commands due to filter");
            return ExecutionResult.STOP;
        }
        Usability usability = Usability.of(this.context, candidate, member, (GuildMessageChannel)event.getGuildChannel(), isNotOwner);
        if (usability.isUnusable()) {
            EnumSet<Usability.UnusableReason> unusableReasons = usability.getUnusableReasons();
            if (unusableReasons.contains((Object)Usability.UnusableReason.HIDDEN)) {
                this.onCommandNotFound(event, candidate.getPath(), true);
                return ExecutionResult.STOP;
            }
            if (unusableReasons.contains((Object)Usability.UnusableReason.OWNER_ONLY)) {
                this.reply(event, this.context.getDefaultMessages(event.getGuild()).getOwnerOnlyErrorMsg());
                return ExecutionResult.STOP;
            }
            if (unusableReasons.contains((Object)Usability.UnusableReason.NSFW_DISABLED)) {
                this.reply(event, this.context.getDefaultMessages(event.getGuild()).getNsfwDisabledErrorMsg());
                return ExecutionResult.STOP;
            }
            if (unusableReasons.contains((Object)Usability.UnusableReason.NSFW_ONLY)) {
                this.reply(event, this.context.getDefaultMessages(event.getGuild()).getNSFWOnlyErrorMsg());
                return ExecutionResult.STOP;
            }
            if (unusableReasons.contains((Object)Usability.UnusableReason.NSFW_DM_DENIED)) {
                this.reply(event, this.context.getDefaultMessages(event.getGuild()).getNSFWDMDeniedErrorMsg());
                return ExecutionResult.STOP;
            }
            if (unusableReasons.contains((Object)Usability.UnusableReason.USER_PERMISSIONS)) {
                this.reply(event, this.context.getDefaultMessages(event.getGuild()).getUserPermErrorMsg());
                return ExecutionResult.STOP;
            }
            if (unusableReasons.contains((Object)Usability.UnusableReason.BOT_PERMISSIONS)) {
                StringJoiner missingBuilder = new StringJoiner(", ");
                EnumSet<Permission> missingPerms = candidate.getBotPermissions();
                missingPerms.removeAll(event.getGuild().getSelfMember().getPermissions((GuildChannel)event.getGuildChannel()));
                for (Permission botPermission : missingPerms) {
                    missingBuilder.add(botPermission.getName());
                }
                this.reply(event, this.context.getDefaultMessages(event.getGuild()).getBotPermErrorMsg(missingBuilder.toString()));
                return ExecutionResult.STOP;
            }
        }
        if (isNotOwner && (cooldown = candidate.getCooldown(event)) > 0L) {
            DefaultMessages messages = this.context.getDefaultMessages(event.getGuild());
            if (candidate.getCooldownScope() == CooldownScope.USER) {
                this.reply(event, messages.getUserCooldownMsg((double)cooldown / 1000.0));
                return ExecutionResult.STOP;
            }
            if (candidate.getCooldownScope() == CooldownScope.GUILD) {
                this.reply(event, messages.getGuildCooldownMsg((double)cooldown / 1000.0));
                return ExecutionResult.STOP;
            }
            this.reply(event, messages.getChannelCooldownMsg((double)cooldown / 1000.0));
            return ExecutionResult.STOP;
        }
        return candidate.execute(this.context, event, args, matcher, throwableConsumer);
    }

    @Nullable
    private TextCommandCandidates getCommandCandidates(String[] split) {
        if (split.length == 0) {
            return null;
        }
        TextCommandCandidates commands = this.context.findCommands(CommandPath.of(split));
        if (commands != null) {
            return commands;
        }
        return this.getCommandCandidates(Arrays.copyOf(split, split.length - 1));
    }

    private void onCommandNotFound(MessageReceivedEvent event, CommandPath commandName, boolean isNotOwner) {
        if (this.context.areSuggestionsDisabled()) {
            return;
        }
        List<String> suggestions = this.getSuggestions(event, commandName, isNotOwner);
        if (!suggestions.isEmpty()) {
            this.reply(event, this.context.getDefaultMessages(event.getGuild()).getCommandNotFoundMsg("**" + String.join((CharSequence)"**, **", suggestions) + "**"));
        }
    }

    @NotNull
    private List<String> getSuggestions(MessageReceivedEvent event, CommandPath triedCommandPath, boolean isNotOwner) {
        Function<CommandPath, String> pathToStringFunc = switch (triedCommandPath.getNameCount()) {
            case 1 -> CommandPath::getName;
            case 2, 3 -> CommandPath::getSubname;
            default -> throw new IllegalStateException("Path empty or longer than 3 !");
        };
        List commandNames = this.context.getCommands().stream().filter(c -> Usability.of(this.context, c.findFirst(), event.getMember(), (GuildMessageChannel)event.getGuildChannel(), isNotOwner).isUsable()).map(c -> (String)pathToStringFunc.apply(c.findFirst().getPath())).collect(Collectors.toList());
        List topPartial = FuzzySearch.extractAll((String)pathToStringFunc.apply(triedCommandPath), commandNames, FuzzySearch::partialRatio, (int)90).stream().map(ExtractedResult::getString).collect(Collectors.toList());
        return FuzzySearch.extractTop((String)pathToStringFunc.apply(triedCommandPath), topPartial, FuzzySearch::ratio, (int)5, (int)42).stream().map(ExtractedResult::getString).collect(Collectors.toList());
    }

    private void runCommand(RunnableEx code, Consumer<Throwable> throwableConsumer) {
        this.commandService.execute(() -> {
            try {
                code.run();
            }
            catch (Throwable e) {
                throwableConsumer.accept(e);
            }
        });
    }

    @NotNull
    private Consumer<Throwable> getThrowableConsumer(MessageReceivedEvent event, String msg) {
        return e -> {
            Message message = event.getMessage();
            ExceptionHandler handler = this.context.getUncaughtExceptionHandler();
            if (handler != null) {
                handler.onException(this.context, (Event)event, (Throwable)e);
                return;
            }
            Throwable baseEx = Utils.getException(e);
            Utils.printExceptionString("Unhandled exception in thread '" + Thread.currentThread().getName() + "' while executing request '" + msg + "'", baseEx);
            message.addReaction(BaseCommandEventImpl.ERROR).queue();
            if (message.getGuildChannel().canTalk()) {
                message.getChannel().sendMessage((CharSequence)this.context.getDefaultMessages(message.getGuild()).getGeneralErrorMsg()).queue();
            }
            this.context.dispatchException(msg, baseEx);
        };
    }

    private void reply(MessageReceivedEvent event, String msg) {
        Object channelAction = event.getGuildChannel().canTalk() ? new CompletedRestAction(event.getJDA(), (Object)event.getChannel()) : event.getAuthor().openPrivateChannel();
        channelAction.queue(channel -> channel.sendMessage((CharSequence)msg).queue(null, (Consumer)new ErrorHandler().ignore(ErrorResponse.CANNOT_SEND_TO_USER, new ErrorResponse[0]).handle(Exception.class, e -> {
            Utils.printExceptionString("Could not send reply message from command listener", e);
            this.context.dispatchException("Could not send reply message from command listener", (Throwable)e);
        })));
    }
}

