/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.prefixed;

import com.freya02.botcommands.api.parameters.RegexParameterResolver;
import com.freya02.botcommands.internal.prefixed.TextCommandInfo;
import com.freya02.botcommands.internal.prefixed.TextCommandParameter;
import com.freya02.botcommands.internal.prefixed.Utils;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class CommandPattern {
    public static Pattern of(TextCommandInfo commandInfo) {
        String exampleStr;
        List<? extends TextCommandParameter> optionParameters = commandInfo.getOptionParameters();
        boolean hasMultipleQuotable = Utils.hasMultipleQuotable(optionParameters);
        List<ParameterPattern> patterns = optionParameters.stream().map(p -> new ParameterPattern((RegexParameterResolver)p.getResolver(), p.isOptional(), hasMultipleQuotable)).toList();
        Pattern pattern = CommandPattern.joinPatterns(patterns);
        if (!pattern.matcher(exampleStr = optionParameters.stream().filter(p -> !p.isOptional()).map(p -> ((RegexParameterResolver)p.getResolver()).getTestExample()).collect(Collectors.joining(" "))).matches()) {
            throw new IllegalArgumentException("Failed building pattern for method " + com.freya02.botcommands.internal.utils.Utils.formatMethodShort(commandInfo.getMethod()) + " with pattern '" + pattern + "' and example '" + exampleStr + "'\nYou can try to either rearrange the arguments as to make a parsable command, especially moving parameters which are parsed from strings, or, use slash commands");
        }
        return pattern;
    }

    public static Pattern joinPatterns(List<ParameterPattern> patterns) {
        int i;
        StringBuilder builder = new StringBuilder(16 * patterns.size());
        builder.append("^");
        SpacePosition[] positions = new SpacePosition[patterns.size()];
        for (i = 0; i < patterns.size() - 1; ++i) {
            ParameterPattern arg0 = patterns.get(i);
            ParameterPattern arg1 = patterns.get(i + 1);
            if (arg0.optional && !arg1.optional) {
                positions[i] = SpacePosition.RIGHT;
                continue;
            }
            positions[i + 1] = !arg0.optional && arg1.optional ? SpacePosition.LEFT : (arg0.optional ? SpacePosition.LEFT : SpacePosition.LEFT);
        }
        int patternsSize = patterns.size();
        for (i = 0; i < patternsSize; ++i) {
            ParameterPattern pattern = patterns.get(i);
            SpacePosition position = positions[i];
            builder.append(pattern.toString(position));
        }
        return Pattern.compile(builder.toString());
    }

    private static enum SpacePosition {
        LEFT,
        RIGHT;

    }

    public static class ParameterPattern {
        private final Pattern pattern;
        private final boolean optional;

        public ParameterPattern(RegexParameterResolver resolver, boolean optional, boolean hasMultipleQuotable) {
            this.optional = optional;
            this.pattern = hasMultipleQuotable ? resolver.getPreferredPattern() : resolver.getPattern();
        }

        public String toString(@Nullable SpacePosition position) {
            if (this.optional) {
                if (position == SpacePosition.LEFT) {
                    return "(?:\\s+" + this.pattern.toString() + ")?";
                }
                if (position == SpacePosition.RIGHT) {
                    return "(?:" + this.pattern.toString() + "\\s+)?";
                }
                return "(?:" + this.pattern.toString() + ")?";
            }
            if (position == SpacePosition.LEFT) {
                return "\\s+" + this.pattern.toString();
            }
            if (position == SpacePosition.RIGHT) {
                return this.pattern.toString() + "\\s+";
            }
            return this.pattern.toString();
        }
    }
}

