/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.prefixed;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.application.CommandPath;
import com.freya02.botcommands.api.prefixed.BaseCommandEvent;
import com.freya02.botcommands.api.prefixed.CommandEvent;
import com.freya02.botcommands.api.prefixed.HelpBuilderConsumer;
import com.freya02.botcommands.api.prefixed.IHelpCommand;
import com.freya02.botcommands.api.prefixed.TextCommand;
import com.freya02.botcommands.api.prefixed.annotations.Category;
import com.freya02.botcommands.api.prefixed.annotations.Description;
import com.freya02.botcommands.api.prefixed.annotations.JDATextCommand;
import com.freya02.botcommands.api.prefixed.annotations.TextOption;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.Usability;
import com.freya02.botcommands.internal.prefixed.TextCommandCandidates;
import com.freya02.botcommands.internal.prefixed.TextCommandInfo;
import com.freya02.botcommands.internal.prefixed.Utils;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.HashSet;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.entities.channel.unions.GuildMessageChannelUnion;
import org.jetbrains.annotations.NotNull;

@Category(value="Utils")
@Description(value="Gives help about a command")
public final class HelpCommand
extends TextCommand
implements IHelpCommand {
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+");
    private final BContext context;

    public HelpCommand(BContext context) {
        this.context = context;
    }

    @JDATextCommand(name="help", description="Gives help for all commands")
    public void execute(CommandEvent event) {
        this.sendGlobalHelp(event);
    }

    @JDATextCommand(name="help", description="Gives help about a command")
    public void execute(BaseCommandEvent event, @TextOption(name="command path", example="help") String commandStr) {
        String[] split = SPACE_PATTERN.split(commandStr);
        if (split.length > 3) {
            event.respond("The command '" + commandStr + "' cannot have more than 3 components").queue();
            return;
        }
        this.sendCommandHelp(event, CommandPath.of(split));
    }

    @Override
    public void onInvalidCommand(@NotNull BaseCommandEvent event, @NotNull CommandPath executedCommandPath) {
        this.sendCommandHelp(event, executedCommandPath);
    }

    private void sendGlobalHelp(BaseCommandEvent event) {
        EmbedBuilder builder = this.generateGlobalHelp(event.getMember(), (GuildMessageChannel)event.getGuildChannel());
        MessageEmbed embed = builder.build();
        event.getAuthor().openPrivateChannel().queue(privateChannel -> event.sendWithEmbedFooterIcon((MessageChannel)privateChannel, embed, event.failureReporter("Unable to send help message")).queue(m -> event.reactSuccess().queue(), t -> event.reactError().queue()), t -> event.getChannel().sendMessage((CharSequence)this.context.getDefaultMessages(event.getGuild()).getClosedDMErrorMsg()).queue());
    }

    private void sendCommandHelp(BaseCommandEvent event, CommandPath cmdPath) {
        TextCommandCandidates candidates = event.getContext().findCommands(cmdPath);
        if (candidates == null) {
            event.respond("Command '" + this.getSpacedPath(cmdPath) + "' does not exist").queue(null, event.failureReporter("Failed to send help"));
            return;
        }
        Member member = event.getMember();
        GuildMessageChannelUnion channel = event.getGuildChannel();
        Usability usability = Usability.of(this.context, (TextCommandInfo)candidates.first(), member, (GuildMessageChannel)channel, !this.context.isOwner(member.getIdLong()));
        if (usability.isNotShowable()) {
            event.respond("Command '" + this.getSpacedPath(cmdPath) + "' does not exist").queue(null, event.failureReporter("Failed to send help"));
            return;
        }
        EmbedBuilder embed = this.generateCommandHelp(event, candidates);
        event.respond(embed.build(), new MessageEmbed[0]).queue();
    }

    private EmbedBuilder generateGlobalHelp(Member member, GuildMessageChannel channel) {
        EmbedBuilder builder = this.context.getDefaultEmbedSupplier().get();
        builder.setTimestamp((TemporalAccessor)Instant.now());
        builder.setColor(member.getColorRaw());
        builder.setFooter("NSFW commands might not be shown\nRun help in an NSFW channel to see them\n");
        TreeMap<String, StringJoiner> categoryBuilderMap = new TreeMap<String, StringJoiner>(String.CASE_INSENSITIVE_ORDER);
        HashSet<String> insertedCommands = new HashSet<String>();
        for (TextCommandCandidates textCommandCandidates : ((BContextImpl)this.context).getCommands()) {
            TextCommandInfo cmd = (TextCommandInfo)textCommandCandidates.first();
            if (!insertedCommands.add(cmd.getPath().getName()) || !Usability.of(this.context, cmd, member, channel, !this.context.isOwner(member.getIdLong())).isShowable()) continue;
            categoryBuilderMap.computeIfAbsent(Utils.getCategory(cmd), s -> new StringJoiner("\n")).add("**" + cmd.getPath().getName() + "** : " + Utils.getNonBlankDescription(cmd));
        }
        for (Map.Entry entry : categoryBuilderMap.entrySet()) {
            builder.addField((String)entry.getKey(), ((StringJoiner)entry.getValue()).toString(), false);
        }
        HelpBuilderConsumer helpBuilderConsumer = this.context.getHelpBuilderConsumer();
        if (helpBuilderConsumer != null) {
            helpBuilderConsumer.accept(builder, true, null);
        }
        return builder;
    }

    @NotNull
    private EmbedBuilder generateCommandHelp(BaseCommandEvent event, TextCommandCandidates candidates) {
        EmbedBuilder builder = Utils.generateCommandHelp(candidates, event);
        builder.setTimestamp((TemporalAccessor)Instant.now());
        builder.setColor(event.getMember().getColorRaw());
        HelpBuilderConsumer helpBuilderConsumer = this.context.getHelpBuilderConsumer();
        if (helpBuilderConsumer != null) {
            helpBuilderConsumer.accept(builder, false, candidates);
        }
        return builder;
    }

    @NotNull
    private String getSpacedPath(CommandPath cmdPath) {
        return cmdPath.toString().replace('/', ' ');
    }
}

