/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.prefixed;

import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.prefixed.BaseCommandEvent;
import com.freya02.botcommands.api.prefixed.TextCommand;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.application.CommandParameter;
import com.freya02.botcommands.internal.prefixed.TextCommandCandidates;
import com.freya02.botcommands.internal.prefixed.TextCommandInfo;
import com.freya02.botcommands.internal.prefixed.TextCommandParameter;
import com.freya02.botcommands.internal.utils.ReflectionUtils;
import com.freya02.botcommands.internal.utils.Utils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.Permission;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class PrefixedCommandsBuilder {
    private static final Logger LOGGER = Logging.getLogger();
    private final BContextImpl context;

    public PrefixedCommandsBuilder(@NotNull BContextImpl context) {
        this.context = context;
    }

    public void processPrefixedCommand(TextCommand command, Method method) {
        try {
            if (!ReflectionUtils.hasFirstParameter(method, BaseCommandEvent.class)) {
                throw new IllegalArgumentException("Prefixed command at " + Utils.formatMethodShort(method) + " must have a BaseCommandEvent or a CommandEvent as first parameter");
            }
            TextCommandInfo info = new TextCommandInfo(this.context, command, method);
            this.context.addTextCommand(info);
            if (info.isRegexCommand()) {
                LOGGER.debug("Added prefixed command path {} for method {} with pattern {}", new Object[]{info.getPath(), Utils.formatMethodShort(method), info.getCompletePattern()});
            } else {
                LOGGER.debug("Added prefixed command path {} for method {}", (Object)info.getPath(), (Object)Utils.formatMethodShort(method));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("An exception occurred while processing prefixed command at " + Utils.formatMethodShort(method), e);
        }
    }

    public void postProcess() {
        this.checkMethodDuplicates();
        LOGGER.info("Loaded {} commands", (Object)this.context.getCommands().size());
        this.printCommands(this.context.getCommands());
    }

    private void printCommands(Collection<TextCommandCandidates> commands) {
        for (TextCommandCandidates candidates : commands) {
            TextCommandInfo command = candidates.findFirst();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Path: {}", (Object)command.getPath());
                for (TextCommandInfo candidate : candidates) {
                    LOGGER.trace("\t- '{}' Bot permission=[{}] User permissions=[{}]", new Object[]{Utils.formatMethodShort(candidate.getMethod()), candidate.getBotPermissions().stream().map(Permission::getName).collect(Collectors.joining(", ")), candidate.getUserPermissions().stream().map(Permission::getName).collect(Collectors.joining(", "))});
                }
                continue;
            }
            LOGGER.debug("\t- '{}' Bot permission=[{}] User permissions=[{}]", new Object[]{command.getPath(), command.getBotPermissions().stream().map(Permission::getName).collect(Collectors.joining(", ")), command.getUserPermissions().stream().map(Permission::getName).collect(Collectors.joining(", "))});
        }
    }

    private void checkMethodDuplicates() {
        for (TextCommandCandidates command : this.context.getCommands()) {
            for (TextCommandInfo info : command) {
                for (TextCommandInfo commandInfo : command) {
                    if (info == commandInfo) continue;
                    Method commandMethod1 = info.getMethod();
                    Method commandMethod2 = commandInfo.getMethod();
                    List<? extends TextCommandParameter> parameters1 = info.getOptionParameters();
                    List<? extends TextCommandParameter> parameters2 = commandInfo.getOptionParameters();
                    if (!parameters1.stream().map(CommandParameter::getParameter).collect(Collectors.toList()).equals(parameters2.stream().map(CommandParameter::getParameter).collect(Collectors.toList()))) continue;
                    throw new IllegalStateException("Method " + Utils.formatMethodShort(commandMethod1) + " has the same parameters as " + Utils.formatMethodShort(commandMethod2));
                }
            }
        }
    }
}

