/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.utils;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.CooldownScope;
import com.freya02.botcommands.api.annotations.AppendMode;
import com.freya02.botcommands.api.annotations.BotPermissions;
import com.freya02.botcommands.api.annotations.Cooldown;
import com.freya02.botcommands.api.annotations.RequireOwner;
import com.freya02.botcommands.api.annotations.UserPermissions;
import com.freya02.botcommands.api.application.annotations.AppOption;
import com.freya02.botcommands.api.application.annotations.Test;
import com.freya02.botcommands.api.application.slash.annotations.ChannelTypes;
import com.freya02.botcommands.api.modals.annotations.ModalData;
import com.freya02.botcommands.api.modals.annotations.ModalInput;
import com.freya02.botcommands.api.prefixed.annotations.Hidden;
import com.freya02.botcommands.api.prefixed.annotations.TextOption;
import com.freya02.botcommands.internal.CooldownStrategy;
import gnu.trove.TLongCollection;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationUtils {
    @NotNull
    public static <T, A extends Annotation> T getAnnotationValue(@NotNull A annotation, @NotNull String methodName) {
        try {
            return (T)annotation.annotationType().getMethod(methodName, new Class[0]).invoke(annotation, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to get annotation value from " + annotation.annotationType().getName() + "#" + methodName, e);
        }
    }

    @Nullable
    public static <T, A extends Annotation> T getAnnotationValue(@NotNull AnnotatedElement element, Class<A> annotationType, String methodName) {
        A annotation = element.getAnnotation(annotationType);
        if (annotation == null) {
            return null;
        }
        return AnnotationUtils.getAnnotationValue(annotation, methodName);
    }

    @NotNull
    public static <T, A extends Annotation> T getAnnotationValue(@NotNull AnnotatedElement element, Class<A> annotationType, String methodName, T defaultVal) {
        A annotation = element.getAnnotation(annotationType);
        if (annotation == null) {
            return defaultVal;
        }
        return AnnotationUtils.getAnnotationValue(annotation, methodName);
    }

    public static CooldownStrategy getEffectiveCooldownStrategy(Method method) {
        Cooldown annotation = method.getAnnotation(Cooldown.class);
        if (annotation == null) {
            return new CooldownStrategy(0L, TimeUnit.MILLISECONDS, CooldownScope.USER);
        }
        return new CooldownStrategy(annotation.cooldown(), annotation.unit(), annotation.cooldownScope());
    }

    public static EnumSet<Permission> getEffectiveUserPermissions(Method method) {
        EnumSet<Permission> permSet = EnumSet.noneOf(Permission.class);
        UserPermissions methodAnnotation = method.getAnnotation(UserPermissions.class);
        UserPermissions classAnnotation = method.getDeclaringClass().getAnnotation(UserPermissions.class);
        Permission[] classPerms = classAnnotation != null ? classAnnotation.value() : new Permission[]{};
        if (methodAnnotation != null) {
            Permission[] methodPerms = methodAnnotation.value();
            Collections.addAll(permSet, methodPerms);
            if (methodAnnotation.mode() == AppendMode.ADD) {
                Collections.addAll(permSet, classPerms);
            }
        } else {
            Collections.addAll(permSet, classPerms);
        }
        return permSet;
    }

    public static EnumSet<Permission> getEffectiveBotPermissions(Method method) {
        EnumSet<Permission> permSet = EnumSet.noneOf(Permission.class);
        BotPermissions methodAnnotation = method.getAnnotation(BotPermissions.class);
        BotPermissions classAnnotation = method.getDeclaringClass().getAnnotation(BotPermissions.class);
        Permission[] classPerms = classAnnotation != null ? classAnnotation.value() : new Permission[]{};
        if (methodAnnotation != null) {
            Permission[] methodPerms = methodAnnotation.value();
            Collections.addAll(permSet, methodPerms);
            if (methodAnnotation.mode() == AppendMode.ADD) {
                Collections.addAll(permSet, classPerms);
            }
        } else {
            Collections.addAll(permSet, classPerms);
        }
        return permSet;
    }

    public static boolean getEffectiveHiddenState(Method method) {
        if (method.isAnnotationPresent(Hidden.class)) {
            return true;
        }
        return method.getDeclaringClass().isAnnotationPresent(Hidden.class);
    }

    public static boolean getEffectiveRequireOwnerState(Method method) {
        if (method.isAnnotationPresent(RequireOwner.class)) {
            return true;
        }
        return method.getDeclaringClass().isAnnotationPresent(RequireOwner.class);
    }

    public static <A extends Annotation> List<A> getEffectiveAnnotations(Method method, Class<A> annotation) {
        A methodAnnotation;
        ArrayList<A> annotations = new ArrayList<A>();
        A classAnnotation = method.getDeclaringClass().getAnnotation(annotation);
        if (classAnnotation != null) {
            annotations.add(classAnnotation);
        }
        if ((methodAnnotation = method.getAnnotation(annotation)) != null) {
            annotations.add(methodAnnotation);
        }
        return annotations;
    }

    public static TLongSet getEffectiveTestGuildIds(BContext context, Method method) {
        TLongHashSet testIds = new TLongHashSet((TLongCollection)context.getTestGuildIds());
        List<Test> effectiveAnnotations = AnnotationUtils.getEffectiveAnnotations(method, Test.class);
        for (Test test : effectiveAnnotations) {
            long[] ids = test.guildIds();
            AppendMode mode = test.mode();
            if (mode == AppendMode.SET) {
                testIds.clear();
                testIds.addAll(ids);
                return testIds;
            }
            if (mode != AppendMode.ADD) continue;
            testIds.addAll(ids);
        }
        return testIds;
    }

    public static boolean isOption(Parameter parameter) {
        return Stream.of(TextOption.class, AppOption.class, ModalData.class, ModalInput.class).anyMatch(parameter::isAnnotationPresent);
    }

    @Nullable
    public static <A extends Annotation> A getEffectiveAnnotation(@NotNull Method method, @NotNull Class<A> annotationType) {
        boolean methodAnnot;
        boolean bl = methodAnnot = method.getAnnotation(annotationType) != null;
        if (methodAnnot) {
            return method.getAnnotation(annotationType);
        }
        return method.getDeclaringClass().getAnnotation(annotationType);
    }

    public static ChannelType[] getEffectiveChannelTypes(Parameter parameter) {
        ChannelTypes annotation = parameter.getAnnotation(ChannelTypes.class);
        if (annotation == null) {
            return new ChannelType[0];
        }
        return annotation.value();
    }

    public static boolean getEffectiveTestState(Method method) {
        return !AnnotationUtils.getEffectiveAnnotations(method, Test.class).isEmpty();
    }
}

