/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.utils;

import com.freya02.botcommands.api.Logging;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BResourceBundle {
    private static final Logger LOGGER = Logging.getLogger();
    private static final Map<String, Map<Locale, BResourceBundle>> cachedBundles = Collections.synchronizedMap(new HashMap());
    @NotNull
    private final ResourceBundle bundle;

    private BResourceBundle(@NotNull ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public static BResourceBundle getBundle(@NotNull String name, @NotNull Locale locale) {
        AtomicBoolean contained = new AtomicBoolean(true);
        Map localeBResourceBundleMap = cachedBundles.computeIfAbsent(name, s -> {
            contained.set(false);
            return Collections.synchronizedMap(new HashMap());
        });
        return localeBResourceBundleMap.computeIfAbsent(locale, l -> {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(name, locale);
                if (bundle.getLocale().toString().isBlank() && !locale.toString().isBlank() && Locale.getDefault() != locale) {
                    LOGGER.warn("Tried to use a {} bundle with locale '{}' but none was found, using default bundle", (Object)name, (Object)locale);
                }
                return new BResourceBundle(bundle);
            }
            catch (MissingResourceException e) {
                if (!contained.get()) {
                    LOGGER.warn("Can't find resource {}.properties which is used for localized strings, localization won't be used", (Object)name);
                }
                return null;
            }
        });
    }

    @NotNull
    public ResourceBundle getBundle() {
        return this.bundle;
    }

    @NotNull
    public String getValueOrDefault(@NotNull String label, @NotNull String defaultVal) {
        if (!this.bundle.containsKey(label)) {
            return defaultVal;
        }
        return this.bundle.getString(label);
    }

    @Nullable
    public String getValue(@NotNull String label) {
        if (!this.bundle.containsKey(label)) {
            return null;
        }
        return this.bundle.getString(label);
    }

    @NotNull
    public String getPathValueOrDefault(@NotNull String defaultVal, Object ... paths) {
        String label = this.getPathLabel(paths);
        if (!this.bundle.containsKey(label)) {
            return defaultVal;
        }
        return this.bundle.getString(label);
    }

    @Nullable
    public String getPathValue(Object ... paths) {
        String label = this.getPathLabel(paths);
        if (!this.bundle.containsKey(label)) {
            return null;
        }
        return this.bundle.getString(label);
    }

    private String getPathLabel(Object ... paths) {
        StringJoiner joiner = new StringJoiner(".");
        for (Object o : paths) {
            joiner.add(o.toString());
        }
        return joiner.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BResourceBundle that = (BResourceBundle)o;
        return this.bundle.equals(that.bundle);
    }

    public int hashCode() {
        return this.bundle.hashCode();
    }
}

