/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.utils;

import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.annotations.ConditionalUse;
import com.freya02.botcommands.api.annotations.Optional;
import com.freya02.botcommands.api.application.CommandScope;
import com.freya02.botcommands.api.application.slash.annotations.DoubleRange;
import com.freya02.botcommands.api.application.slash.annotations.LongRange;
import com.freya02.botcommands.internal.utils.Utils;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.BaseTypeSignature;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodInfoList;
import io.github.classgraph.MethodParameterInfo;
import io.github.classgraph.ScanResult;
import io.github.classgraph.TypeSignature;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.slf4j.Logger;

public class ReflectionUtils {
    private static final StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private static final Logger LOGGER = Logging.getLogger();
    private static final Map<Parameter, Map<Class<?>, Annotation>> paramAnnotationsMap = new HashMap();

    @NotNull
    public static Set<Class<?>> scanPackagesAndClasses(Set<String> packageNames, Set<Class<?>> manualClasses) {
        boolean hasClasses;
        boolean hasPackages = !packageNames.isEmpty();
        boolean bl = hasClasses = !manualClasses.isEmpty();
        if (!hasPackages && !hasClasses) {
            LOGGER.warn("No packages or classes were registered");
            return Collections.emptySet();
        }
        try (ScanResult scanResult = new ClassGraph().acceptPackages((String[])packageNames.toArray(String[]::new)).acceptClasses((String[])manualClasses.stream().map(Class::getName).toArray(String[]::new)).enableMethodInfo().enableAnnotationInfo().scan();){
            ClassInfoList allStandardClasses = scanResult.getAllStandardClasses();
            if (allStandardClasses.isEmpty()) {
                if (hasPackages && !hasClasses) {
                    LOGGER.warn("No classes have been found as nothing was found in packages and no classes were manually registered");
                    LOGGER.warn("Packages: {}", (Object)String.join((CharSequence)", ", packageNames));
                } else if (hasPackages) {
                    LOGGER.error("No classes have been found despite packages and classes being added, please report this to the developers");
                    LOGGER.error("Packages: {}", (Object)String.join((CharSequence)", ", packageNames));
                    LOGGER.error("Classes: {}", (Object)manualClasses.stream().map(Class::getSimpleName).collect(Collectors.joining(", ")));
                }
            }
            ClassInfoList instantiableClasses = allStandardClasses.filter(ReflectionUtils::isInstantiable);
            ReflectionUtils.scanAnnotations(instantiableClasses);
            Set<Class<?>> set = Set.copyOf(instantiableClasses.loadClasses());
            return set;
        }
    }

    private static boolean isInstantiable(ClassInfo classInfo) {
        try {
            BaseTypeSignature baseTypeSignature;
            MethodInfoList methodInfos = classInfo.getDeclaredMethodInfo().filter(m -> m.hasAnnotation(ConditionalUse.class));
            if (methodInfos.isEmpty()) {
                return true;
            }
            if (methodInfos.size() > 1) {
                throw new IllegalArgumentException("Class %s must have at most one method annotated with @%s".formatted(classInfo.getSimpleName(), ConditionalUse.class.getSimpleName()));
            }
            MethodInfo methodInfo = (MethodInfo)methodInfos.get(0);
            if (!methodInfo.isStatic()) {
                throw new IllegalArgumentException("@%s at %s#%s must be static".formatted(ConditionalUse.class.getSimpleName(), classInfo.getSimpleName(), methodInfo.getName()));
            }
            if (methodInfo.getParameterInfo().length != 0) {
                throw new IllegalArgumentException("@%s at %s#%s must have 0 parameters".formatted(ConditionalUse.class.getSimpleName(), classInfo.getSimpleName(), methodInfo.getName()));
            }
            TypeSignature typeSignature = methodInfo.getTypeSignatureOrTypeDescriptor().getResultType();
            if (!(typeSignature instanceof BaseTypeSignature) || (baseTypeSignature = (BaseTypeSignature)typeSignature).getType() != Boolean.TYPE) {
                throw new IllegalArgumentException("@%s at %s#%s must return a boolean".formatted(ConditionalUse.class.getSimpleName(), classInfo.getSimpleName(), methodInfo.getName()));
            }
            Method method = methodInfo.loadClassAndGetMethod();
            if (!method.canAccess(null)) {
                throw new IllegalArgumentException("@%s at %s#%s must be public".formatted(ConditionalUse.class.getSimpleName(), classInfo.getSimpleName(), methodInfo.getName()));
            }
            return (Boolean)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static void scanAnnotations(ClassInfoList instantiableClasses) {
        for (ClassInfo instantiableClass : instantiableClasses) {
            for (MethodInfo methodInfo : instantiableClass.getDeclaredMethodInfo()) {
                Parameter[] parameters = methodInfo.loadClassAndGetMethod().getParameters();
                int j = 0;
                for (MethodParameterInfo parameterInfo : methodInfo.getParameterInfo()) {
                    Parameter parameter = parameters[j++];
                    for (AnnotationInfo annotationInfo : parameterInfo.getAnnotationInfo()) {
                        paramAnnotationsMap.computeIfAbsent(parameter, x -> new HashMap()).put(annotationInfo.getClassInfo().loadClass(), annotationInfo.loadClassAndInstantiate());
                    }
                }
            }
        }
    }

    public static boolean hasFirstParameter(Method method, Class<?> type) {
        return method.getParameterCount() > 0 && type.isAssignableFrom(method.getParameterTypes()[0]);
    }

    public static void checkApplicationCommandParameter(Method method, CommandScope scope, Class<?> globalType, Class<?> guildType) {
        if (method.getParameterCount() == 0) {
            throw new IllegalArgumentException("Application command at " + Utils.formatMethodShort(method) + " must have a " + guildType.getSimpleName() + " or " + globalType.getSimpleName() + " as first parameter");
        }
        Class<?> firstParamType = method.getParameterTypes()[0];
        if (scope.isGuildOnly()) {
            if (!firstParamType.isAssignableFrom(guildType)) {
                throw new IllegalArgumentException("Application command at " + Utils.formatMethodShort(method) + " must have a " + guildType.getSimpleName() + " or " + globalType.getSimpleName() + " as first parameter");
            }
            if (!guildType.isAssignableFrom(firstParamType)) {
                LOGGER.warn("Guild-only application command {} uses {}, consider using {} to remove warnings related to guild stuff's nullability", new Object[]{Utils.formatMethodShort(method), firstParamType.getSimpleName(), guildType.getSimpleName()});
            }
        } else if (!firstParamType.isAssignableFrom(globalType)) {
            throw new IllegalArgumentException("Application command at " + Utils.formatMethodShort(method) + " must have a " + globalType.getSimpleName() + " as first parameter");
        }
    }

    public static boolean isOptional(Parameter parameter) {
        Map<Class<?>, Annotation> map = paramAnnotationsMap.get(parameter);
        if (map == null) {
            return false;
        }
        return map.containsKey(Optional.class) || map.containsKey(Nullable.class);
    }

    @Nullable
    public static LongRange getLongRange(Parameter parameter) {
        Map<Class<?>, Annotation> map = paramAnnotationsMap.get(parameter);
        if (map == null) {
            return null;
        }
        return (LongRange)map.get(LongRange.class);
    }

    @Nullable
    public static DoubleRange getDoubleRange(Parameter parameter) {
        Map<Class<?>, Annotation> map = paramAnnotationsMap.get(parameter);
        if (map == null) {
            return null;
        }
        return (DoubleRange)map.get(DoubleRange.class);
    }

    @NotNull
    public static String formatFrameMethod(@NotNull StackWalker.StackFrame frame) {
        return "[Line %d] %s#%s(%s)".formatted(frame.getLineNumber(), frame.getDeclaringClass().getSimpleName(), frame.getMethodName(), frame.getMethodType().parameterList().stream().map(Class::getSimpleName).collect(Collectors.joining(", ")));
    }

    @NotNull
    public static String formatCallerMethod() {
        StackWalker.StackFrame callerFrame = ReflectionUtils.getFrame(3);
        if (callerFrame == null) {
            throw new IllegalStateException("Found no method caller");
        }
        return ReflectionUtils.formatFrameMethod(callerFrame);
    }

    @NotNull
    public static StackWalker.StackFrame getCallerFrame() {
        StackWalker.StackFrame callerFrame = ReflectionUtils.getFrame(3);
        if (callerFrame == null) {
            throw new IllegalStateException("Found no method caller");
        }
        return callerFrame;
    }

    @Nullable
    public static StackWalker.StackFrame getFrame(@Range(from=0L, to=0x7FFFFFFFL) int skip) {
        return walker.walk(stackFrameStream -> stackFrameStream.skip(skip).findFirst().orElse(null));
    }

    @Nullable
    public static Class<?> getCollectionReturnType(Class<?> returnClass, Type returnType) {
        ParameterizedType type;
        Class rawType;
        if (returnType instanceof ParameterizedType && Collection.class.isAssignableFrom(rawType = (Class)(type = (ParameterizedType)returnType).getRawType()) && type.getOwnerType() == null) {
            return (Class)type.getActualTypeArguments()[0];
        }
        ArrayList superclasses = new ArrayList();
        ArrayList<Type> supertypes = new ArrayList<Type>();
        if (returnClass.getGenericSuperclass() != null) {
            superclasses.add(returnClass.getSuperclass());
            supertypes.add(returnClass.getGenericSuperclass());
        }
        superclasses.addAll(Arrays.asList(returnClass.getInterfaces()));
        supertypes.addAll(Arrays.asList(returnClass.getGenericInterfaces()));
        int supertypesSize = supertypes.size();
        for (int i = 0; i < supertypesSize; ++i) {
            Class<?> listReturnType = ReflectionUtils.getCollectionReturnType((Class)superclasses.get(i), (Type)supertypes.get(i));
            if (listReturnType == null) continue;
            return listReturnType;
        }
        return null;
    }

    @Nullable
    public static Class<?> getCollectionReturnType(@NotNull Method method) {
        Type returnType = method.getGenericReturnType();
        return ReflectionUtils.getCollectionReturnType(method.getReturnType(), returnType);
    }

    @NotNull
    public static Class<?> getCollectionTypeOrBoxedSelfType(@NotNull Parameter parameter) {
        Class<?> type = ReflectionUtils.getCollectionReturnType(parameter.getType(), parameter.getParameterizedType());
        if (type == null) {
            return Utils.getBoxedType(parameter.getType());
        }
        return type;
    }
}

