/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.utils;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.components.ComponentManager;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.exceptions.ErrorResponseException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class Utils {
    private static final char[] chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!\"#$%&'()*+,-./:;<=>?_^[]{}|".toCharArray();
    private static final Logger LOGGER = Logging.getLogger();

    @Contract(value="null, _ -> fail")
    @NotNull
    public static String requireNonBlank(String str, String name) {
        if (str == null) {
            throw new IllegalArgumentException(name + " may not be null");
        }
        if (str.isBlank()) {
            throw new IllegalArgumentException(name + " may not be blank");
        }
        return str;
    }

    public static ExecutorService createCommandPool(ThreadFactory factory) {
        return new ThreadPoolExecutor(4, Runtime.getRuntime().availableProcessors() * 4, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), factory);
    }

    public static void printExceptionString(String message, Throwable e) {
        CharArrayWriter out = new CharArrayWriter(1024);
        out.append(message).append("\n");
        PrintWriter printWriter = new PrintWriter(out);
        e.printStackTrace(printWriter);
        LOGGER.error(out.toString());
    }

    @NotNull
    public static Throwable getException(Throwable e) {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    public static ErrorResponseException getErrorResponseException(Throwable e) {
        do {
            if (!(e instanceof ErrorResponseException)) continue;
            ErrorResponseException ex = (ErrorResponseException)e;
            return ex;
        } while ((e = e.getCause()) != null);
        return null;
    }

    public static String randomId(int n) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        StringBuilder sb = new StringBuilder(64);
        for (int i = 0; i < n; ++i) {
            sb.append(chars[random.nextInt(0, chars.length)]);
        }
        return sb.toString();
    }

    @NotNull
    public static ComponentManager getComponentManager(BContext context) {
        if (context == null) {
            throw new IllegalStateException("The ComponentManager must be set in CommandsBuilder in order to use components (no BContext so assuming it didn't get set)");
        }
        ComponentManager componentManager = context.getComponentManager();
        if (componentManager == null) {
            throw new IllegalStateException("The ComponentManager must be set in CommandsBuilder in order to use components");
        }
        return componentManager;
    }

    public static Class<?> getBoxedType(Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type == Double.TYPE) {
                return Double.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Float.TYPE) {
                return Float.class;
            }
            if (type == Byte.TYPE) {
                return Byte.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
            LOGGER.error("Cannot box type {}", (Object)type.getName());
            return type;
        }
        return type;
    }

    @NotNull
    public static String formatMethodShort(@NotNull Method method) {
        return method.getDeclaringClass().getSimpleName() + "#" + method.getName() + Arrays.stream(method.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", ", "(", ")"));
    }

    public static String readResource(String url) {
        String string;
        block9: {
            Class<?> callerClass = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass();
            InputStream stream = callerClass.getResourceAsStream(url);
            try {
                if (stream == null) {
                    throw new RuntimeException("Unable to read resource at " + url + " for class " + callerClass.getName());
                }
                string = new String(stream.readAllBytes());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to read resource at " + url + " for class " + callerClass.getName(), e);
                }
            }
            stream.close();
        }
        return string;
    }

    @Contract(value="null -> fail; !null -> param1", pure=true)
    @NotNull
    public static <T> T checkGuild(T t) {
        if (t == null) {
            throw new IllegalArgumentException("Guild-only object was null, so the interaction may not have happened in a Guild");
        }
        return t;
    }
}

