/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.subethamail.smtp.client.AuthenticationNotSupportedException;
import org.subethamail.smtp.client.Authenticator;
import org.subethamail.smtp.client.SMTPException;
import org.subethamail.smtp.client.SmartClient;
import org.subethamail.smtp.util.Base64;

public class PlainAuthenticator
implements Authenticator {
    private final String user;
    private final String password;
    private final SmartClient smartClient;

    public PlainAuthenticator(SmartClient smartClient, String user, String password) {
        this.smartClient = smartClient;
        this.user = user;
        this.password = password;
    }

    @Override
    public void authenticate() throws SMTPException, AuthenticationNotSupportedException, IOException {
        this.checkAuthPlainSupport();
        String initialClientResponse = this.constructInitialClientResponse();
        this.smartClient.sendAndCheck("AUTH PLAIN " + initialClientResponse);
    }

    private void checkAuthPlainSupport() throws AuthenticationNotSupportedException {
        String mechanismsString = this.smartClient.getExtensions().get("AUTH");
        if (mechanismsString == null) {
            throw new AuthenticationNotSupportedException("Cannot authenticate, because the AUTH extension is not supported by the server. Maybe the server expects TLS first");
        }
        Set<String> mechanisms = this.parseMechanismsList(mechanismsString);
        if (!mechanisms.contains("PLAIN")) {
            throw new AuthenticationNotSupportedException("Cannot authenticate, because the PLAIN mechanism is not supported by the server. Maybe the server expects TLS first");
        }
    }

    private Set<String> parseMechanismsList(String authParameters) {
        String[] mechanisms = authParameters.split(" ");
        return new HashSet<String>(Arrays.asList(mechanisms));
    }

    private String constructInitialClientResponse() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        out.write(0);
        out.write(this.user.getBytes("UTF-8"));
        out.write(0);
        out.write(this.password.getBytes("UTF-8"));
        return Base64.encodeToString(out.toByteArray(), false);
    }
}

