/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.client.AuthenticationNotSupportedException;
import org.subethamail.smtp.client.Authenticator;
import org.subethamail.smtp.client.SMTPClient;
import org.subethamail.smtp.client.SMTPException;

public class SmartClient
extends SMTPClient {
    private static Logger log = LoggerFactory.getLogger(SmartClient.class);
    boolean sentFrom;
    int recipientCount;
    private String heloHost;
    private boolean serverClosingTransmissionChannel = false;
    private final Map<String, String> extensions = new HashMap<String, String>();
    private Authenticator authenticator = null;

    public SmartClient() {
    }

    public SmartClient(String host, int port, String myHost) throws UnknownHostException, IOException, SMTPException {
        this(host, port, null, myHost);
    }

    public SmartClient(String host, int port, SocketAddress bindpoint, String myHost) throws UnknownHostException, IOException, SMTPException {
        this.setBindpoint(bindpoint);
        this.setHeloHost(myHost);
        this.connect(host, port);
    }

    @Override
    public void connect(String host, int port) throws SMTPException, AuthenticationNotSupportedException, IOException {
        if (this.heloHost == null) {
            throw new IllegalStateException("Helo host must be specified before connecting");
        }
        super.connect(host, port);
        try {
            this.receiveAndCheck();
            this.sendHeloOrEhlo();
            if (this.authenticator != null) {
                this.authenticator.authenticate();
            }
        }
        catch (SMTPException e) {
            this.quit();
            throw e;
        }
        catch (AuthenticationNotSupportedException e) {
            this.quit();
            throw e;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    protected void sendHeloOrEhlo() throws IOException, SMTPException {
        this.extensions.clear();
        SMTPClient.Response resp = this.sendReceive("EHLO " + this.heloHost);
        if (resp.isSuccess()) {
            this.parseEhloResponse(resp);
        } else if (resp.getCode() == 500 || resp.getCode() == 502) {
            this.sendAndCheck("HELO " + this.heloHost);
        } else {
            throw new SMTPException(resp);
        }
    }

    private void parseEhloResponse(SMTPClient.Response resp) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(resp.getMessage()));
        reader.readLine();
        while (null != (line = reader.readLine())) {
            int iFirstSpace = line.indexOf(32);
            String keyword = iFirstSpace == -1 ? line : line.substring(0, iFirstSpace);
            String parameters = iFirstSpace == -1 ? "" : line.substring(iFirstSpace + 1);
            this.extensions.put(keyword.toUpperCase(Locale.ENGLISH), parameters);
        }
    }

    @Override
    protected SMTPClient.Response receive() throws IOException {
        SMTPClient.Response response = super.receive();
        if (response.getCode() == 421) {
            this.serverClosingTransmissionChannel = true;
        }
        return response;
    }

    public void from(String from) throws IOException, SMTPException {
        this.sendAndCheck("MAIL FROM: <" + from + ">");
        this.sentFrom = true;
    }

    public void to(String to) throws IOException, SMTPException {
        this.sendAndCheck("RCPT TO: <" + to + ">");
        ++this.recipientCount;
    }

    public void dataStart() throws IOException, SMTPException {
        this.sendAndCheck("DATA");
    }

    public void dataWrite(byte[] data, int numBytes) throws IOException {
        this.dataOutput.write(data, 0, numBytes);
    }

    public void dataEnd() throws IOException, SMTPException {
        this.dataOutput.flush();
        this.dotTerminatedOutput.writeTerminatingSequence();
        this.dotTerminatedOutput.flush();
        this.receiveAndCheck();
    }

    public void quit() {
        try {
            if (this.isConnected() && !this.serverClosingTransmissionChannel) {
                this.sendAndCheck("QUIT");
            }
        }
        catch (IOException ex) {
            log.warn("Failed to issue QUIT to " + this.hostPort);
        }
        this.close();
    }

    public boolean sentFrom() {
        return this.sentFrom;
    }

    public boolean sentTo() {
        return this.recipientCount > 0;
    }

    public int getRecipientCount() {
        return this.recipientCount;
    }

    public Map<String, String> getExtensions() {
        return this.extensions;
    }

    public void setHeloHost(String myHost) {
        this.heloHost = myHost;
    }

    public String getHeloHost() {
        return this.heloHost;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }
}

