/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.helper;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.MessageHandler;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.TooMuchDataException;
import org.subethamail.smtp.helper.SimpleMessageListener;
import org.subethamail.smtp.io.DeferredFileOutputStream;

public class SimpleMessageListenerAdapter
implements MessageHandlerFactory {
    private static int DEFAULT_DATA_DEFERRED_SIZE = 0x500000;
    private Collection<SimpleMessageListener> listeners;
    private int dataDeferredSize;

    public SimpleMessageListenerAdapter(SimpleMessageListener listener) {
        this(Set.of(listener), DEFAULT_DATA_DEFERRED_SIZE);
    }

    public SimpleMessageListenerAdapter(Collection<SimpleMessageListener> listeners) {
        this(listeners, DEFAULT_DATA_DEFERRED_SIZE);
    }

    public SimpleMessageListenerAdapter(Collection<SimpleMessageListener> listeners, int dataDeferredSize) {
        this.listeners = listeners;
        this.dataDeferredSize = dataDeferredSize;
    }

    @Override
    public MessageHandler create(MessageContext ctx) {
        return new Handler(ctx);
    }

    class Handler
    implements MessageHandler {
        MessageContext ctx;
        String from;
        List<Delivery> deliveries = new ArrayList<Delivery>();

        public Handler(MessageContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void from(String from) throws RejectException {
            this.from = from;
        }

        @Override
        public void recipient(String recipient) throws RejectException {
            boolean addedListener = false;
            for (SimpleMessageListener listener : SimpleMessageListenerAdapter.this.listeners) {
                if (!listener.accept(this.from, recipient)) continue;
                this.deliveries.add(new Delivery(listener, recipient));
                addedListener = true;
            }
            if (!addedListener) {
                throw new RejectException(553, "<" + recipient + "> address unknown.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void data(InputStream data) throws TooMuchDataException, IOException {
            if (this.deliveries.size() == 1) {
                Delivery delivery = this.deliveries.get(0);
                delivery.getListener().deliver(this.from, delivery.getRecipient(), data);
            } else {
                try (DeferredFileOutputStream dfos = new DeferredFileOutputStream(SimpleMessageListenerAdapter.this.dataDeferredSize);){
                    int value;
                    while ((value = data.read()) >= 0) {
                        dfos.write(value);
                    }
                    for (Delivery delivery : this.deliveries) {
                        delivery.getListener().deliver(this.from, delivery.getRecipient(), dfos.getInputStream());
                    }
                }
            }
        }

        @Override
        public void done() {
        }
    }

    static class Delivery {
        SimpleMessageListener listener;
        String recipient;

        public SimpleMessageListener getListener() {
            return this.listener;
        }

        public String getRecipient() {
            return this.recipient;
        }

        public Delivery(SimpleMessageListener listener, String recipient) {
            this.listener = listener;
            this.recipient = recipient;
        }
    }
}

