/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class CRLFTerminatedReader
extends Reader {
    static int MAX_LINE_LENGTH = 998;
    InputStream in;
    private StringBuffer lineBuffer = new StringBuffer();
    private final int EOF = -1;
    private final int CR = 13;
    private final int LF = 10;
    private int tainted = -1;

    public CRLFTerminatedReader(InputStream in) {
        this.in = in;
    }

    public CRLFTerminatedReader(InputStream in, String enc) throws UnsupportedEncodingException {
        this(in);
    }

    public String readLine() throws IOException {
        this.lineBuffer.delete(0, this.lineBuffer.length());
        boolean cr_just_received = false;
        do {
            int inChar = this.read();
            if (!cr_just_received) {
                switch (inChar) {
                    case 13: {
                        cr_just_received = true;
                        break;
                    }
                    case -1: {
                        return null;
                    }
                    case 10: {
                        if (this.tainted == -1) {
                            this.tainted = this.lineBuffer.length();
                        }
                    }
                    default: {
                        this.lineBuffer.append((char)inChar);
                        break;
                    }
                }
                continue;
            }
            switch (inChar) {
                case 10: {
                    if (this.tainted != -1) {
                        int pos = this.tainted;
                        this.tainted = -1;
                        throw new TerminationException("\"bare\" CR or LF in data stream", pos);
                    }
                    return this.lineBuffer.toString();
                }
                case -1: {
                    return null;
                }
                case 13: {
                    if (this.tainted == -1) {
                        this.tainted = this.lineBuffer.length();
                    }
                    this.lineBuffer.append((char)this.CR);
                    break;
                }
                default: {
                    if (this.tainted == -1) {
                        this.tainted = this.lineBuffer.length();
                    }
                    this.lineBuffer.append((char)this.CR);
                    this.lineBuffer.append((char)inChar);
                    cr_just_received = false;
                }
            }
        } while (this.lineBuffer.length() < MAX_LINE_LENGTH);
        throw new MaxLineLengthException("Input line length is too long!");
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public boolean ready() throws IOException {
        return this.in.available() > 0;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        byte[] temp = new byte[len];
        int result = this.in.read(temp, 0, len);
        for (int i = 0; i < result; ++i) {
            cbuf[i] = (char)temp[i];
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public class TerminationException
    extends IOException {
        private int where;

        public TerminationException(int where) {
            this.where = where;
        }

        public TerminationException(String s, int where) {
            super(s);
            this.where = where;
        }

        public int position() {
            return this.where;
        }
    }

    public class MaxLineLengthException
    extends IOException {
        public MaxLineLengthException() {
        }

        public MaxLineLengthException(String s) {
            super(s);
        }
    }
}

