/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.io.IOException;
import org.subethamail.smtp.DropConnectionException;
import org.subethamail.smtp.server.Command;
import org.subethamail.smtp.server.CommandException;
import org.subethamail.smtp.server.HelpMessage;
import org.subethamail.smtp.server.Session;

public class RequireTLSCommandWrapper
implements Command {
    private Command wrapped;

    public RequireTLSCommandWrapper(Command wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public void execute(String commandString, Session sess) throws IOException, DropConnectionException {
        if (!sess.getServer().getRequireTLS() || sess.isTLSStarted()) {
            this.wrapped.execute(commandString, sess);
        } else {
            sess.sendResponse("530 Must issue a STARTTLS command first");
        }
    }

    @Override
    public HelpMessage getHelp() throws CommandException {
        return this.wrapped.getHelp();
    }

    @Override
    public String getName() {
        return this.wrapped.getName();
    }
}

