/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.subethamail.smtp.server.SMTPServer;
import org.subethamail.smtp.server.Session;

class ServerThread
extends Thread {
    private final Logger log = LoggerFactory.getLogger(ServerThread.class);
    private final SMTPServer server;
    private final ServerSocket serverSocket;
    private final Semaphore connectionPermits;
    @GuardedBy(value="this")
    private final Set<Session> sessionThreads;
    private volatile boolean shuttingDown;

    public ServerThread(SMTPServer server, ServerSocket serverSocket) {
        super(ServerThread.class.getName() + " " + server.getDisplayableLocalSocketAddress());
        this.server = server;
        this.serverSocket = serverSocket;
        int countOfConnectionPermits = server.getMaxConnections() + 10;
        this.connectionPermits = new Semaphore(countOfConnectionPermits);
        this.sessionThreads = new HashSet<Session>(countOfConnectionPermits * 4 / 3 + 1);
    }

    @Override
    public void run() {
        MDC.put((String)"smtpServerLocalSocketAddress", (String)this.server.getDisplayableLocalSocketAddress());
        this.log.info("SMTP server {} started", (Object)this.server.getDisplayableLocalSocketAddress());
        try {
            this.runAcceptLoop();
            this.log.info("SMTP server {} stopped accepting connections", (Object)this.server.getDisplayableLocalSocketAddress());
        }
        catch (RuntimeException e) {
            this.log.error("Unexpected exception in server socket thread, server is stopped", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            this.log.error("Unexpected error in server socket thread, server is stopped", (Throwable)e);
            throw e;
        }
        finally {
            MDC.remove((String)"smtpServerLocalSocketAddress");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAcceptLoop() {
        while (!this.shuttingDown) {
            try {
                this.connectionPermits.acquire();
            }
            catch (InterruptedException consumed) {
                continue;
            }
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException e) {
                this.connectionPermits.release();
                if (this.shuttingDown) continue;
                this.log.error("Error accepting connection", (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Session session = null;
            try {
                session = new Session(this.server, this, socket);
            }
            catch (IOException e) {
                this.connectionPermits.release();
                this.log.error("Error while starting a connection", (Throwable)e);
                try {
                    socket.close();
                }
                catch (IOException e1) {
                    this.log.debug("Cannot close socket after exception", (Throwable)e1);
                }
                continue;
            }
            ServerThread e = this;
            synchronized (e) {
                this.sessionThreads.add(session);
            }
            try {
                this.server.getExecutorService().execute(session);
            }
            catch (RejectedExecutionException e2) {
                this.connectionPermits.release();
                ServerThread e1 = this;
                synchronized (e1) {
                    this.sessionThreads.remove(session);
                }
                this.log.error("Error while executing a session", (Throwable)e2);
                try {
                    socket.close();
                }
                catch (IOException e3) {
                    this.log.debug("Cannot close socket after exception", (Throwable)e3);
                }
            }
        }
    }

    public void shutdown() {
        this.shutdownServerThread();
        this.shutdownSessions();
    }

    private void shutdownServerThread() {
        this.shuttingDown = true;
        this.closeServerSocket();
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void closeServerSocket() {
        try {
            this.serverSocket.close();
            this.log.debug("SMTP Server socket shut down");
        }
        catch (IOException e) {
            this.log.error("Failed to close server socket.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownSessions() {
        ArrayList<Session> sessionsToBeClosed;
        ServerThread serverThread = this;
        synchronized (serverThread) {
            sessionsToBeClosed = new ArrayList<Session>(this.sessionThreads);
        }
        for (Session sessionThread : sessionsToBeClosed) {
            sessionThread.quit();
        }
        this.server.getExecutorService().shutdown();
        try {
            this.server.getExecutorService().awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted waiting for termination of session threads", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public synchronized boolean hasTooManyConnections() {
        return this.sessionThreads.size() > this.server.getMaxConnections();
    }

    public synchronized int getNumberOfConnections() {
        return this.sessionThreads.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEnded(Session session) {
        ServerThread serverThread = this;
        synchronized (serverThread) {
            this.sessionThreads.remove(session);
        }
        this.connectionPermits.release();
    }
}

