/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.wiser;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import org.subethamail.wiser.Wiser;

public class WiserMessage {
    byte[] messageData;
    Wiser wiser;
    String envelopeSender;
    String envelopeReceiver;

    WiserMessage(Wiser wiser, String envelopeSender, String envelopeReceiver, byte[] messageData) {
        this.wiser = wiser;
        this.envelopeSender = envelopeSender;
        this.envelopeReceiver = envelopeReceiver;
        this.messageData = messageData;
    }

    public MimeMessage getMimeMessage() throws MessagingException {
        return new MimeMessage(this.wiser.getSession(), (InputStream)new ByteArrayInputStream(this.messageData));
    }

    public byte[] getData() {
        return this.messageData;
    }

    public String getEnvelopeReceiver() {
        return this.envelopeReceiver;
    }

    public String getEnvelopeSender() {
        return this.envelopeSender;
    }

    public void dumpMessage(PrintStream out) throws MessagingException {
        out.println("===== Dumping message =====");
        out.println("Envelope sender: " + this.getEnvelopeSender());
        out.println("Envelope recipient: " + this.getEnvelopeReceiver());
        String content = new String(this.getData());
        out.println(content);
        out.println("===== End message dump =====");
    }

    public String toString() {
        if (this.getData() == null) {
            return "";
        }
        return new String(this.getData());
    }
}

