/*
 * Decompiled with CFR 0.152.
 */
package io.github.millij.poi.ss.reader;

import io.github.millij.poi.SpreadsheetReadException;
import io.github.millij.poi.ss.handler.RowListener;
import io.github.millij.poi.ss.reader.SpreadsheetReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSpreadsheetReader
implements SpreadsheetReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSpreadsheetReader.class);

    AbstractSpreadsheetReader() {
    }

    @Override
    public <T> void read(Class<T> beanClz, File file, RowListener<T> callback) throws SpreadsheetReadException {
        try (FileInputStream fis = new FileInputStream(file);){
            this.read(beanClz, (InputStream)fis, callback);
        }
        catch (IOException ex) {
            String errMsg = String.format("Failed to read file as Stream : %s", ex.getMessage());
            throw new SpreadsheetReadException(errMsg, ex);
        }
    }

    @Override
    public <T> void read(Class<T> beanClz, File file, int sheetNo, RowListener<T> callback) throws SpreadsheetReadException {
        try {
            FileInputStream fis = new FileInputStream(file);
            this.read(beanClz, fis, sheetNo, callback);
        }
        catch (IOException ex) {
            String errMsg = String.format("Failed to read file as Stream : %s", ex.getMessage());
            throw new SpreadsheetReadException(errMsg, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> List<T> read(Class<T> beanClz, File file) throws SpreadsheetReadException {
        try (FileInputStream fis = new FileInputStream(file);){
            List<T> list = this.read(beanClz, fis);
            return list;
        }
        catch (IOException ex) {
            String errMsg = String.format("Failed to read file as Stream : %s", ex.getMessage());
            throw new SpreadsheetReadException(errMsg, ex);
        }
    }

    @Override
    public <T> List<T> read(Class<T> beanClz, InputStream is) throws SpreadsheetReadException {
        final ArrayList sheetBeans = new ArrayList();
        this.read(beanClz, is, new RowListener<T>(){

            @Override
            public void row(int rowNum, T rowObj) {
                if (rowObj == null) {
                    LOGGER.error("Null object returned for row : {}", (Object)rowNum);
                    return;
                }
                sheetBeans.add(rowObj);
            }
        });
        return sheetBeans;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> List<T> read(Class<T> beanClz, File file, int sheetNo) throws SpreadsheetReadException {
        try (FileInputStream fis = new FileInputStream(file);){
            List<T> list = this.read(beanClz, (InputStream)fis, sheetNo);
            return list;
        }
        catch (IOException ex) {
            String errMsg = String.format("Failed to read file as Stream : %s", ex.getMessage());
            throw new SpreadsheetReadException(errMsg, ex);
        }
    }

    @Override
    public <T> List<T> read(Class<T> beanClz, InputStream is, int sheetNo) throws SpreadsheetReadException {
        final ArrayList sheetBeans = new ArrayList();
        this.read(beanClz, is, sheetNo, new RowListener<T>(){

            @Override
            public void row(int rowNum, T rowObj) {
                if (rowObj == null) {
                    LOGGER.error("Null object returned for row : {}", (Object)rowNum);
                    return;
                }
                sheetBeans.add(rowObj);
            }
        });
        return sheetBeans;
    }
}

